/*
 * OgreBulletExample.h
 *
 *  Created on: Feb 3, 2011
 *      Author: cpresser
 */

#ifndef TUTORIAL1_H_
#define TUTORIAL1_H_

#include "BaseApplication.h"

#include <OgreBulletDynamicsRigidBody.h>
#include <deque>

class OgreBulletExample: public BaseApplication {
public:
	OgreBulletExample();
	virtual ~OgreBulletExample();

	void createScene();

	//frame listener methods
    // Ogre::FrameListener
    virtual bool frameRenderingQueued(const Ogre::FrameEvent& evt);
    virtual bool frameStarted (const Ogre::FrameEvent &evt);
    virtual bool frameEnded (const Ogre::FrameEvent &evt);

    // OIS::KeyListener
    virtual bool keyPressed( const OIS::KeyEvent &arg );
    virtual bool keyReleased( const OIS::KeyEvent &arg );
    virtual void createConcaveRigidBodyObject(Ogre::String mesh,
    		Ogre::Vector3 position = Ogre::Vector3::ZERO);

protected:
    //fire a block
    virtual void fireBlock();

    OgreBulletDynamics::DynamicsWorld *m_world;
    OgreBulletCollisions::DebugDrawer *m_debugDrawer;

    int m_numEntities;
    int m_moveSpeed;
    Ogre::Vector3 m_gravity;
    Ogre::AxisAlignedBox m_bounds;

    Ogre::Real m_cubeSpeed;
    Ogre::Vector3 m_direction;

    std::deque<OgreBulletDynamics::RigidBody *> m_bodies;
    std::deque<OgreBulletCollisions::CollisionShape *> m_shapes;

    Ogre::SceneNode *m_sphereNode;
    OgreBulletDynamics::RigidBody *m_sphereBody;


    bool m_startMoving;
    OgreBulletCollisions::CollisionShape *objShape;
};

#endif /* TUTORIAL1_H_ */
