/***************************************************************************

This source file is part of OGREBULLET
(Object-oriented Graphics Rendering Engine Bullet Wrapper)
For the latest info, see http://www.ogre3d.org/phpBB2addons/viewforum.php?f=10

Copyright (c) 2007 tuan.kuranes@gmail.com (Use it Freely, even Statically, but have to contribute any changes)



Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
-----------------------------------------------------------------------------
*/
#ifndef _OGREBULLETDYNAMICS_TypedConstraint_H
#define _OGREBULLETDYNAMICS_TypedConstraint_H

#include "OgreBulletDynamicsPreRequisites.h"

#include "OgreBulletCollisionsObject.h"


namespace OgreBulletDynamics
{
    // -------------------------------------------------------------------------
    // basic constraint class
    class TypedConstraint
    {
    public:
        TypedConstraint(DynamicsWorld *world);
        TypedConstraint(RigidBody *bodyA);
        TypedConstraint(RigidBody *bodyA, RigidBody *bodyB);

	    virtual ~TypedConstraint();


        inline btTypedConstraint* getBulletTypedConstraint() const {return static_cast <btTypedConstraint*> (mConstraint);};

    protected:
        btTypedConstraint       *mConstraint;

        DynamicsWorld           *mWorld;
        RigidBody               *mBodyA;
        RigidBody               *mBodyB;
	}; 
	// basic constraint action class
	class ActionInterface
	{
	public:
		ActionInterface(DynamicsWorld *world);
		ActionInterface(RigidBody *bodyA);
		ActionInterface(RigidBody *bodyA, RigidBody *bodyB); 

		virtual ~ActionInterface();


		inline btActionInterface* getBulletActionInterface() const {return static_cast <btActionInterface*> (mActionInterface);};

	protected:
		btActionInterface       *mActionInterface;

		DynamicsWorld           *mWorld;
		RigidBody               *mBodyA;
		RigidBody               *mBodyB;
	};
}
#endif //_OGREBULLETDYNAMICS_TypedConstraint_H
