/*
 * CupGame.cpp
 *
 *  Created on: Feb 3, 2011
 *      Author: cpresser
 */

#include "CupGame.h"
#include <OgreBulletCollisionsShape.h>
#include <Shapes/OgreBulletCollisionsStaticPlaneShape.h>
#include <Shapes/OgreBulletCollisionsBoxShape.h>
#include <Shapes/OgreBulletCollisionsSphereShape.h>
#include <Shapes/OgreBulletCollisionsGImpactShape.h>
#include <Shapes/OgreBulletCollisionsTrimeshShape.h>
#include <Shapes/OgreBulletCollisionsCompoundShape.h>
#include <Utils/OgreBulletCollisionsMeshToShapeConverter.h>


CupGame::CupGame():
	m_numEntities(0),
	m_moveSpeed(100),
	m_gravity(0, -9.81, 0),
	m_bounds(),
	m_cubeSpeed(30),
	m_direction(0,0,0),
	m_startMoving(false),
	objShape(0)

{

}

CupGame::~CupGame() {
	//empty the queues, free memory
	std::deque<OgreBulletDynamics::RigidBody *>::iterator itBody = m_bodies.begin();
	while(m_bodies.end() != itBody){
		delete *itBody;
		++itBody;
	}

	std::deque<OgreBulletCollisions::CollisionShape *>::iterator itShape = m_shapes.begin();
	while(m_shapes.end() != itShape){
		delete *itShape;
		++itShape;
	}

	m_bodies.clear();
	m_shapes.clear();

	delete m_world;

}

void CupGame::createScene(void)
{
	//perform the magic required to make textures work
	//Ogre::TextureManager::getSingleton().setDefaultNumMipmaps(0);

	//create the scene stuff

    // Set ambient light
    mSceneMgr->setAmbientLight(Ogre::ColourValue(0.5, 0.5, 0.5));

    // Create a light
    Ogre::Light* l = mSceneMgr->createLight("MainLight");
    l->setPosition(20,80,50);


    //move camera
    mCamera->move(Ogre::Vector3(100, 150, 350));
    mCamera->pitch(Ogre::Degree(-20));

	////////////////////////////////////////////////////////////////////////////
	//set up OgreBullet
	m_world = new OgreBulletDynamics::DynamicsWorld(mSceneMgr, m_bounds, m_gravity);
	m_debugDrawer = new OgreBulletCollisions::DebugDrawer();
	m_debugDrawer->setDrawWireframe(true);

	m_world->setDebugDrawer(m_debugDrawer);
	m_world->setShowDebugShapes(true);


//build a floor
	  Ogre::Plane plane(Ogre::Vector3::UNIT_Y, 0);

	  Ogre::MeshManager::getSingleton().createPlane("ground",
							Ogre::ResourceGroupManager::DEFAULT_RESOURCE_GROUP_NAME,
							plane, 200000, 200000, 20, 20, true, 1, 9000, 9000,
							Ogre::Vector3::UNIT_Z);

	  Ogre::Entity* entGround = mSceneMgr->createEntity("GroundEntity", "ground");
	  mSceneMgr->getRootSceneNode()->createChildSceneNode()->attachObject(entGround);

	  entGround->setMaterialName("Examples/Rockwall");
	  entGround->setCastShadows(false);

	  //add collision detection to the floor
	  OgreBulletCollisions::CollisionShape *shape;

	  //params: normal vector, distance
	  shape = new OgreBulletCollisions::StaticPlaneCollisionShape(
			  Ogre::Vector3::UNIT_Y, 0);

	  OgreBulletDynamics::RigidBody *defaultPlaneBody =
			  new OgreBulletDynamics::RigidBody("BasePlane", m_world);

	  //params: shape, restitution, friction
	  defaultPlaneBody->setStaticShape(shape, 0.1, 0.8);

	  //store the new objects
	  m_bodies.push_back(defaultPlaneBody);
	  m_shapes.push_back(shape);

	//////////////////////////////////////////////////////////////////////////////

//try making the camera collidable
	  //This doesn't work......
	  /*
	  OgreBulletCollisions::BoxCollisionShape *cameraShape =
			  	 new OgreBulletCollisions::BoxCollisionShape(Ogre::Vector3(5, 5, 5));

	  OgreBulletDynamics::RigidBody *cameraBody =
			  new OgreBulletDynamics::RigidBody("CameraBody", m_world);
	  cameraBody->setShape(mCamera->getParentSceneNode(), cameraShape, 0, 0, 1);
	  */



	  //m_bodies.push_back(m_sphereBody);
	  //m_shapes.push_back(sphereShape);

	  Ogre::Real dx = 25;
	  //Ogre::Real dy = ;
	  Ogre::Real dz = 25;
	  int dim = 10;
	  for(int i = 0; i < dim; i++){
		  for(int j = 0; j < dim; j++){

			  createConcaveRigidBodyObject("goblet.mesh", Ogre::Vector3(i*dx, 15, j*dz));
		  }
	  }
}


bool CupGame::mousePressed( const OIS::MouseEvent &arg, OIS::MouseButtonID id ){
	bool result = BaseApplication::mousePressed(arg, id);

	if(arg.state.buttonDown(OIS::MB_Left) ){
		fireBlock();
	}
	return result;
}



bool CupGame::keyPressed(const OIS::KeyEvent & arg)
{
	bool result = BaseApplication::keyPressed(arg);

	switch(arg.key){
	case OIS::KC_B:
		//fire a block
		fireBlock();
		break;
	default:
		break;
	}
//std::cerr << m_direction << std::endl;
	return result;
}

bool CupGame::keyReleased(const OIS::KeyEvent & arg)
{
	bool result = BaseApplication::keyReleased(arg);

	return result;
}



bool CupGame::frameEnded(const Ogre::FrameEvent & evt)
{
	bool result = BaseApplication::frameEnded(evt);

	//m_world->stepSimulation(evt.timeSinceLastFrame);

	return result;
}



bool CupGame::frameStarted(const Ogre::FrameEvent & evt)
{
	bool result = BaseApplication::frameStarted(evt);

	m_world->stepSimulation(evt.timeSinceLastFrame);

	return result;
}



bool CupGame::frameRenderingQueued(const Ogre::FrameEvent & evt)
{
	bool result = BaseApplication::frameRenderingQueued(evt);

	//move the sphere?
	//m_sphereNode->translate(m_direction*evt.timeSinceLastFrame);
	//Ogre::Vector3 pos = m_sphereNode->getPosition();
//	Ogre::Vector3 newPos = pos + m_direction*evt.timeSinceLastFrame;
	//m_sphereBody->setPosition(newPos);
	//m_sphereNode->setPosition(newPos);
	//m_sphereBody->setLinearVelocity(m_direction*evt.timeSinceLastFrame);

	/*
	if(m_startMoving){
		std::cerr << "ACT:" << m_sphereBody->getBulletRigidBody()->getActivationState() << std::endl;
		m_sphereBody->getBulletRigidBody()->forceActivationState(ACTIVE_TAG);
		std::cerr << "ACT:" << m_sphereBody->getBulletRigidBody()->getActivationState() << std::endl;

		m_startMoving=false;
	}
*/
	/*
	if(m_startMoving){
		m_sphereBody->enableActiveState();
	}
	m_sphereBody->applyImpulse(m_direction*evt.timeSinceLastFrame, Ogre::Vector3::ZERO);
	*/
	return result;
}

void CupGame::fireBlock(){

	//position of new block
	Ogre::Vector3 position = mCamera->getDerivedPosition() +
			mCamera->getDerivedDirection().normalisedCopy() * 10;

	//create an entity
	Ogre::Entity *cubeEntity = mSceneMgr->createEntity("Cube" +
			Ogre::StringConverter::toString(m_numEntities),
			"sphere.mesh");

	cubeEntity->setCastShadows(true);

	Ogre::AxisAlignedBox bound = cubeEntity->getBoundingBox();
	Ogre::Vector3 size = bound.getSize();
	size /= 2.0f;
	//size *= 0.95f;

	cubeEntity->setMaterialName("Examples/BumpyMetal");

	//create a node
	Ogre::SceneNode *cubeNode = mSceneMgr->getRootSceneNode()->createChildSceneNode();
	cubeNode->attachObject(cubeEntity);

	//scale both the node and the size
	cubeNode->scale(0.05f, 0.05f, 0.05f);
	size *= 0.05f;

	//create bullet stuff
	OgreBulletCollisions::SphereCollisionShape *cubeShape =
			new OgreBulletCollisions::SphereCollisionShape(size.y);

	OgreBulletDynamics::RigidBody *cubeBody =
			new OgreBulletDynamics::RigidBody("CubeRigid" +
					Ogre::StringConverter::toString(m_numEntities),
					m_world);

	cubeBody->setShape(cubeNode,
			cubeShape,
			0.6f, //dynamic restitution
			0.6f, //dynamic friction
			1.0f, //dynamic body mass
			position, //starting position
			Ogre::Quaternion(0, 0, 0, 1)  //oreientation
			);

	m_numEntities++;

	cubeBody->setLinearVelocity(mCamera->getDerivedDirection().normalisedCopy() * m_moveSpeed);
	cubeBody->setDamping(0.1, 0.1);

	m_shapes.push_back(cubeShape);
	m_bodies.push_back(cubeBody);
}

void CupGame::createConcaveRigidBodyObject(Ogre::String mesh, Ogre::Vector3 position){
	//entity
	Ogre::Entity *objEntity = mSceneMgr->createEntity("Object_" +
			Ogre::StringConverter::toString(m_numEntities),
			mesh);

	objEntity->setCastShadows(true);

	//node
	Ogre::SceneNode *objNode = mSceneMgr->getRootSceneNode()->createChildSceneNode();
	objNode->attachObject(objEntity);


	//collision shape
	//OgreBulletCollisions::StaticMeshToShapeConverter makeShape(objEntity);
	//OgreBulletCollisions::CollisionShape *objShape = makeShape.createSphere();
	//OgreBulletCollisions::CollisionShape *objShape = makeShape.createConcave();
	//OgreBulletCollisions::CollisionShape *objShape = makeShape.createConvexDecomposition();

	if(!objShape){
		OgreBulletCollisions::StaticMeshToShapeConverter makeShape(objEntity);
		objShape = makeShape.createConvexDecomposition();
	}
	//rigid body
	OgreBulletDynamics::RigidBody *objBody =
			new OgreBulletDynamics::RigidBody("ObjRigid" +
					Ogre::StringConverter::toString(m_numEntities),
					m_world);

	//objBody->getBulletRigidBody()->setCollisionShape(makeShape.createConcave());
	objBody->setShape(objNode, objShape, 0.6f, 0.6f, 10.0f, position);
	//objBody->setStaticShape(objNode, objShape, 0.6f, 0.6f, position);

	m_numEntities++;

	m_shapes.push_back(objShape);
	m_bodies.push_back(objBody);
}

#if OGRE_PLATFORM == OGRE_PLATFORM_WIN32
#define WIN32_LEAN_AND_MEAN
#include "windows.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if OGRE_PLATFORM == OGRE_PLATFORM_WIN32
    INT WINAPI WinMain( HINSTANCE hInst, HINSTANCE, LPSTR strCmdLine, INT )
#else
    int main(int argc, char *argv[])
#endif
    {
        // Create application object
        CupGame app;

        try
        {
            app.go();
        } catch( Ogre::Exception& e ) {
#if OGRE_PLATFORM == OGRE_PLATFORM_WIN32
            MessageBox( NULL, e.getFullDescription().c_str(), "An exception has occured!", MB_OK | MB_ICONERROR| MB_TASKMODAL);
#else
            std::cerr << "An exception has occured: " << e.getFullDescription().c_str() << std::endl;
#endif
        }

        return 0;
    }

#ifdef __cplusplus
}


#endif
