/*
 * German.cpp
 *
 *  Created on: Apr 13, 2015
 *      Author: kohaje01
 */


#include "German.h"
using namespace Ogre;

//flag powers should be a power of two
//const Ogre::uint32 Breakout::SELECTABLE = 1;
const Ogre::uint32 German::INTERSECTABLE = 1;
//---------------------------------------------------------------------------
German::German(void)
{
	mDirection = Vector3::ZERO;
	mBDirection = Vector3::ZERO;
	mIntersected = 0; //NULL
	mRaySceneQuery = 0;
	mIntersectionQuery = 0;
	mOldPosition;
	guiRoot = 0;
	mShutDown = false;
	mStarted = false;
	mPaused = false;
	mGameStarted = false;
	mShown = true;
	mEntered = false;
	isGUI = false;
	numBlocks = 0;
	numBWanted = 10;
	ballsRem = 5;
	level = 1;
	currScore = 0;
	playerEnt = 0;
	sinbadNode = 0;
	runBase = 0;
	runTop = 0;
	m_direction = Ogre::Vector3::ZERO;
	moveSpeed = 100;
	m_camNode = 0;
	mYaw = 0;
	yawDeg = 80;
	answer = "";
	isChosen = false;
	toHide = false;
	isOver = false;
	numObjects = 0;
}
//---------------------------------------------------------------------------
German::~German(void)
{
	if(mRaySceneQuery) {
		mSceneMgr->destroyQuery(mRaySceneQuery);
	}
	if(mIntersectionQuery) {
		mSceneMgr->destroyQuery(mIntersectionQuery);
	}
}

CEGUI::MouseButton convertButton(OIS::MouseButtonID buttonID)
{
	switch (buttonID)
	{
	case OIS::MB_Left:
		return CEGUI::LeftButton;

	case OIS::MB_Right:
		return CEGUI::RightButton;

	case OIS::MB_Middle:
		return CEGUI::MiddleButton;

	default:
		return CEGUI::LeftButton;
	}
}

bool German::frameRenderingQueued(const Ogre::FrameEvent& evt) {
	bool result = BaseApplication::frameRenderingQueued(evt);

	if(mShutDown)
		return false;

	if(!isGUI) {
		Ogre::Real time = evt.timeSinceLastFrame;
		if(time != 0) {
			sinbadNode->translate(m_direction*time, Ogre::Node::TS_LOCAL);
			sinbadNode->yaw(mYaw*time);
			runBase->addTime(time);
			runTop->addTime(time);
		}
	}
	else {
		guiRoot->getChild("InfoBox")->show();
		if(guiRoot->getChild("HouseBox")->isVisible()) {
			guiRoot->getChild("HouseBox")->setProperty("Text", answer);
			if(isChosen) {
				Ogre::String correct = "DAS HAUS";
				if(answer == correct || answer == "EIN HAUS"){
					guiRoot->getChild("RightBox")->show();
				}
				else {
					guiRoot->getChild("WrongBox")->setProperty("Text", "Nein, die Antwort war: " + correct);
					guiRoot->getChild("WrongBox")->show();
				}
			}
			if(toHide) {
				mSceneMgr->getEntity("House")->detachFromParent();
				guiRoot->getChild("HouseBox")->hide();
				guiRoot->getChild("RightBox")->hide();
				guiRoot->getChild("WrongBox")->hide();
				guiRoot->getChild("InfoBox")->hide();
				answer = "";
				toHide = false;
				isChosen = false;
				isGUI = false;
				numObjects--;
			}
		}
		if(guiRoot->getChild("PlaneBox")->isVisible()) {
			guiRoot->getChild("PlaneBox")->setProperty("Text", answer);
			if(isChosen) {
				Ogre::String correct = "DAS FLUGZEUG";
				if(answer == correct || answer == "EIN FLUGZEUG"){
					guiRoot->getChild("RightBox")->show();
				}
				else {
					guiRoot->getChild("WrongBox")->setProperty("Text", "Nein, die Antwort war: " + correct);
					guiRoot->getChild("WrongBox")->show();
				}
			}
			if(toHide) {
				mSceneMgr->getEntity("Plane")->detachFromParent();
				guiRoot->getChild("PlaneBox")->hide();
				guiRoot->getChild("RightBox")->hide();
				guiRoot->getChild("WrongBox")->hide();
				guiRoot->getChild("InfoBox")->hide();
				answer = "";
				toHide = false;
				isChosen = false;
				isGUI = false;
				numObjects--;
			}
		}
		if(guiRoot->getChild("FishBox")->isVisible()) {
			guiRoot->getChild("FishBox")->setProperty("Text", answer);
			if(isChosen) {
				Ogre::String correct = "DER FISCH";
				if(answer == correct || answer == "EIN FISCH"){
					guiRoot->getChild("RightBox")->show();
				}
				else {
					guiRoot->getChild("WrongBox")->setProperty("Text", "Nein, die Antwort war: " + correct);
					guiRoot->getChild("WrongBox")->show();
				}
			}
			if(toHide) {
				mSceneMgr->getEntity("fish")->detachFromParent();
				guiRoot->getChild("FishBox")->hide();
				guiRoot->getChild("RightBox")->hide();
				guiRoot->getChild("WrongBox")->hide();
				guiRoot->getChild("InfoBox")->hide();
				answer = "";
				toHide = false;
				isChosen = false;
				isGUI = false;
				numObjects--;
			}
		}
		if(guiRoot->getChild("DragonBox")->isVisible()) {
			guiRoot->getChild("DragonBox")->setProperty("Text", answer);
			if(isChosen) {
				Ogre::String correct = "DER DRACHE";
				if(answer == correct || answer == "EIN DRACHE"){
					guiRoot->getChild("RightBox")->show();
				}
				else {
					guiRoot->getChild("WrongBox")->setProperty("Text", "Nein, die Antwort war: " + correct);
					guiRoot->getChild("WrongBox")->show();
				}
			}
			if(toHide) {
				mSceneMgr->getEntity("dragon")->detachFromParent();
				guiRoot->getChild("DragonBox")->hide();
				guiRoot->getChild("RightBox")->hide();
				guiRoot->getChild("WrongBox")->hide();
				guiRoot->getChild("InfoBox")->hide();
				answer = "";
				toHide = false;
				isChosen = false;
				isGUI = false;
				numObjects--;
			}
		}
	}

	if(numObjects == 0) {
		guiRoot->getChild("End")->show();
		isOver = true;
	}

	mIntersectionQuery->execute(this);

	mOldPosition = sinbadNode->getPosition();

	return result;
}

//---------------------------------------------------------------------------
void German::createScene(void)
{
	// Create your scene here :)
	// Set the scene's ambient light
	mSceneMgr->setAmbientLight(Ogre::ColourValue(0.5f, 0.5f, 0.5f));

	setupGUI();

	// Create a Light and set its position
	Ogre::Light* light = mSceneMgr->createLight("MainLight");
	light->setPosition(20.0f, 80.0f, 50.0f);

	mSceneMgr->setSkyBox(true, "Examples/CloudyNoonSkyBox");

	//build a ground
	Ogre::Plane plane(Ogre::Vector3::UNIT_Y, -25);
	Ogre::Plane plane2(Ogre::Vector3::UNIT_X, -350);
	Ogre::Plane plane3(Ogre::Vector3::NEGATIVE_UNIT_X, -350);
	Ogre::Plane plane5(Ogre::Vector3::UNIT_Z, -350);
	Ogre::Plane plane6(Ogre::Vector3::NEGATIVE_UNIT_Z, -350);

	//create geometry
	Ogre::MeshManager::getSingleton().createPlane("ground",
			Ogre::ResourceGroupManager::DEFAULT_RESOURCE_GROUP_NAME,
			plane, 700, 700, 40, 40, true, 1, 6, 6, Ogre::Vector3::UNIT_Z);

	Ogre::Entity* entGround = mSceneMgr->createEntity("GroundEntity", "ground");
	mSceneMgr->getRootSceneNode()->createChildSceneNode()->attachObject(entGround);

	entGround->setMaterialName("Examples/GrassFloor");
	entGround->setCastShadows(false);

	Ogre::MeshManager::getSingleton().createPlane("leftWall",
			Ogre::ResourceGroupManager::DEFAULT_RESOURCE_GROUP_NAME,
			plane2, 50, 700, 5, 5, true, 1, 1, 1, Ogre::Vector3::UNIT_Z);

	Ogre::Entity* entLeftWall = mSceneMgr->createEntity("LeftWallEntity", "leftWall");
	mSceneMgr->getRootSceneNode()->createChildSceneNode()->attachObject(entLeftWall);

	entLeftWall->setMaterialName("Template/Wood");
	entLeftWall->setQueryFlags(INTERSECTABLE);

	Ogre::MeshManager::getSingleton().createPlane("rightWall",
			Ogre::ResourceGroupManager::DEFAULT_RESOURCE_GROUP_NAME,
			plane3, 50, 700, 40, 40, true, 1, 1, 1, Ogre::Vector3::UNIT_Z);

	Ogre::Entity* entRightWall = mSceneMgr->createEntity("RightWallEntity", "rightWall");
	mSceneMgr->getRootSceneNode()->createChildSceneNode()->attachObject(entRightWall);

	entRightWall->setMaterialName("Template/Wood");
	entRightWall->setQueryFlags(INTERSECTABLE);

	Ogre::MeshManager::getSingleton().createPlane("FarWall",
			Ogre::ResourceGroupManager::DEFAULT_RESOURCE_GROUP_NAME,
			plane5, 50, 700, 40, 40, true, 1, 1, 1, Ogre::Vector3::UNIT_X);

	Ogre::Entity* entFarWall = mSceneMgr->createEntity("FarWallEntity", "FarWall");
	mSceneMgr->getRootSceneNode()->createChildSceneNode()->attachObject(entFarWall);

	entFarWall->setMaterialName("Template/Wood");
	entFarWall->setQueryFlags(INTERSECTABLE);

	Ogre::MeshManager::getSingleton().createPlane("CloseWall",
			Ogre::ResourceGroupManager::DEFAULT_RESOURCE_GROUP_NAME,
			plane6, 50, 700, 40, 40, true, 1, 1, 1, Ogre::Vector3::UNIT_X);

	Ogre::Entity* entCloseWall = mSceneMgr->createEntity("CloseWallEntity", "CloseWall");
	mSceneMgr->getRootSceneNode()->createChildSceneNode()->attachObject(entCloseWall);

	entCloseWall->setMaterialName("Template/Wood");
	//entCloseWall->setQueryFlags(INTERSECTABLE);

	playerEnt = mSceneMgr->createEntity("Sinbad", "Sinbad.mesh");
	sinbadNode = mSceneMgr->getRootSceneNode()->createChildSceneNode("SinbadNode");
	sinbadNode->attachObject(playerEnt);
	sinbadNode->scale(5, 5, 5);
	runBase = playerEnt->getAnimationState("RunBase");
	runTop = playerEnt->getAnimationState("RunTop");
	playerEnt->setQueryFlags(INTERSECTABLE);

	m_camNode = sinbadNode->createChildSceneNode();
	//	m_camNode->setInheritOrientation(false);

	Ogre::SceneNode * m_camSubNode = m_camNode->createChildSceneNode();
	m_camSubNode->attachObject(mCamera);
	//m_camNode->setPosition(Ogre::Vector3(0, CAMERA_Y_OFFSET, CAMERA_Z_OFFSET));
	//m_camSubNode->setPosition(Ogre::Vector3(0, CAMERA_Y_OFFSET, CAMERA_Z_OFFSET));
	m_camSubNode->translate(Ogre::Vector3(0, 20, -175), Ogre::Node::TS_WORLD);
	mCamera->lookAt(Ogre::Vector3(0, 10, 300));

	Ogre::Entity* houseEnt = mSceneMgr->createEntity("House", "tudorhouse.mesh");
	Ogre::SceneNode* house = mSceneMgr->getRootSceneNode()->createChildSceneNode("HouseNode");
	house->attachObject(houseEnt);
	house->scale(.4, .4, .4);
	house->translate(Ogre::Vector3(-300, 75, 200));
	houseEnt->setQueryFlags(INTERSECTABLE);
	numObjects++;

	Ogre::Entity* razorEnt = mSceneMgr->createEntity("Plane", "razor.mesh");
	Ogre::SceneNode* razor = mSceneMgr->getRootSceneNode()->createChildSceneNode("PlaneNode");
	razor->attachObject(razorEnt);
	razor->scale(.6, .6, .6);
	razor->translate(Ogre::Vector3(-300, 0, -200));
	numObjects++;

	Ogre::Entity* fishEnt = mSceneMgr->createEntity("fish", "fish.mesh");
	Ogre::SceneNode* fish = mSceneMgr->getRootSceneNode()->createChildSceneNode("fishNode");
	fish->attachObject(fishEnt);
	fish->scale(5, 5, 5);
	fish->translate(Ogre::Vector3(300, 0, 200));
	numObjects++;

	Ogre::Entity* dragonEnt = mSceneMgr->createEntity("dragon", "dragon.mesh");
	Ogre::SceneNode* dragon = mSceneMgr->getRootSceneNode()->createChildSceneNode("dragonNode");
	dragon->attachObject(dragonEnt);
	dragon->scale(.5, .5, .5);
	dragon->translate(Ogre::Vector3(200, 50, -200));
	numObjects++;
}


void German::createCamera(void) {
	BaseApplication::createCamera();
	//	mCamera->setPosition(0, 0, 350)
//	mCamera->getViewport()->setOverlaysEnabled(false);
}

void German::createFrameListener(void) {
	BaseApplication::createFrameListener();

	//init scene query
	mRaySceneQuery = mSceneMgr->createRayQuery(Ogre::Ray());
	mIntersectionQuery = mSceneMgr->createIntersectionQuery(INTERSECTABLE);
}

//void German::createViewports(void) {
//	//Create first view port
//	BaseApplication::createViewports();
//
//	//rewrite of BaseApplications' method
//	Ogre::Viewport* vp = mWindow->addViewport(mCamera);
//	vp->setBackgroundColour(Ogre::ColourValue(0.5, 0.5, 0.5));
////
//	vp->setDimensions(0, 0, 1, 1);
////
//	vp->setOverlaysEnabled(false);
////
////	// Alter the camera aspect ratio to match the viewport
//	mCamera->setAspectRatio(Ogre::Real(vp->getActualWidth())
//	/ Ogre::Real(vp->getActualHeight()));
//
//	Ogre::Camera *camera2 = mSceneMgr->getCamera("TopCamera");
//	//2nd param is z order, which to draw first, first viewport has default 0, 1 gets drawn 2nd
//	Ogre::Viewport* vp2 = mWindow->addViewport(camera2, 1);
//
//	//set the viewport's dimensions
//	vp2->setDimensions(.75, 0, .25, 1);
//
//	//set the camera's aspect ratio to fit the space
//	camera2->setAspectRatio(Ogre::Real(vp2->getActualWidth()) / Ogre::Real(vp2->getActualHeight()));
//
//	//get rid of extra Ogre stuff
//	vp2->setOverlaysEnabled(false);
//}

void German::setupGUI(){

	mRenderer = &CEGUI::OgreRenderer::bootstrapSystem();

	CEGUI::ImageManager::setImagesetDefaultResourceGroup("Imagesets");
	CEGUI::Font::setDefaultResourceGroup("Fonts");
	CEGUI::Scheme::setDefaultResourceGroup("Schemes");
	CEGUI::WidgetLookManager::setDefaultResourceGroup("LookNFeel");
	CEGUI::WindowManager::setDefaultResourceGroup("Layouts");
	//
	//	//Loading scheme
	CEGUI::SchemeManager::getSingleton().createFromFile("TaharezLook.scheme");
	//
	//	//Set the mouse cursor
//	CEGUI::System::getSingleton().getDefaultGUIContext().getMouseCursor().setDefaultImage("TaharezLook/MouseTarget");
	//
	CEGUI::WindowManager &wmgr = CEGUI::WindowManager::getSingleton();
	//
	//	//load our file
	guiRoot = wmgr.loadLayoutFromFile("ModelViewer.layout");
	//
	//	//set up the main window
	CEGUI::System::getSingleton().getDefaultGUIContext().setRootWindow(guiRoot);

	//Event handling
	//NOTE: PushButton is the CEGUI Object
	//Button is the type defined in the XML file
//		guiRoot->getChild("QuitButton")->subscribeEvent(CEGUI::PushButton::EventClicked, //which event to call
//				CEGUI::Event::Subscriber(&German::quit, //method to call, giving the address of a function, not a call (no parentheses)
//						this)); //object to call it on

	guiRoot->getChild("HouseBox")->hide();
	//	guiRoot->getChild("ControlBox")->setProperty("Text",
	//			"Click 'b' to toggle this box\nBrick Guide:\nRock-20pts\nRed-30 pts and the paddle is bigger\nGreen-40pts and the ball is bigger.\nYellow-50pts\nPurple-60pts");
	//
	//	guiRoot->getChild("HighScores")->hide();
	////	guiRoot->getChild("HighScores")->setProperty("Text", score->print());
	//
	guiRoot->getChild("InfoBox")->hide();
	guiRoot->getChild("RightBox")->hide();
	guiRoot->getChild("WrongBox")->hide();
	guiRoot->getChild("PlaneBox")->hide();
	guiRoot->getChild("FishBox")->hide();
	guiRoot->getChild("DragonBox")->hide();
	guiRoot->getChild("End")->hide();
}


bool German::keyPressed(const OIS::KeyEvent& arg) {
	switch(arg.key) {
	case OIS::KC_ESCAPE:
		mShutDown = true;
		break;
	case OIS::KC_RETURN:
		if(isChosen) {
			toHide = true;
		}
		if(isOver) {
			mShutDown = true;
		}
		isChosen = true;
		break;
	case OIS::KC_RIGHT:
	case OIS::KC_D:
		runBase->setLoop(true);
		runTop->setLoop(true);
		//		runBase->setEnabled(true);
		//		runTop->setEnabled(true);
		//		m_direction.z = -moveSpeed;
		mYaw = -yawDeg;
		if(isGUI) {
			answer += "D";
		}
		break;
	case OIS::KC_LEFT:
	case OIS::KC_A:
		runBase->setLoop(true);
		runTop->setLoop(true);
		//		runBase->setEnabled(true);
		//		runTop->setEnabled(true);
		//		m_direction.z = moveSpeed;
		mYaw = yawDeg;
		if(isGUI) {
			answer += "A";
		}
		break;
	case OIS::KC_UP:
	case OIS::KC_W:
		runBase->setLoop(true);
		runTop->setLoop(true);
		runBase->setEnabled(true);
		runTop->setEnabled(true);
		m_direction.z = moveSpeed;
		if(isGUI) {
			answer += "W";
		}
		break;
	case OIS::KC_DOWN:
	case OIS::KC_S:
		runBase->setLoop(true);
		runTop->setLoop(true);
		runBase->setEnabled(true);
		runTop->setEnabled(true);
		m_direction.z = -moveSpeed;
		if(isGUI) {
			answer += "S";
		}
		break;

		//	case OIS::KC_A:
		//		answer += "A";
		//		break;
		if(isGUI) {
	case OIS::KC_B:
		answer += "B";
		break;
	case OIS::KC_C:
		answer += "C";
		break;
		//	case OIS::KC_D:
		//		answer += "D";
		//		break;
	case OIS::KC_E:
		answer += "E";
		break;
	case OIS::KC_F:
		answer += "F";
		break;
	case OIS::KC_G:
		answer += "G";
		break;
	case OIS::KC_H:
		answer += "H";
		break;
	case OIS::KC_I:
		answer += "I";
		break;
	case OIS::KC_J:
		answer += "J";
		break;
	case OIS::KC_K:
		answer += "K";
		break;
	case OIS::KC_L:
		answer += "L";
		break;
	case OIS::KC_M:
		answer += "M";
		break;
	case OIS::KC_N:
		answer += "N";
		break;
	case OIS::KC_O:
		answer += "O";
		break;
	case OIS::KC_P:
		answer += "P";
		break;
	case OIS::KC_Q:
		answer += "Q";
		break;
	case OIS::KC_R:
		answer += "R";
		break;
		//	case OIS::KC_S:
		//		answer += "S";
		//		break;
	case OIS::KC_T:
		answer += "T";
		break;
	case OIS::KC_U:
		answer += "U";
		break;
	case OIS::KC_V:
		answer += "V";
		break;
		//	case OIS::KC_W:
		//		answer += "W";
		//		break;
	case OIS::KC_X:
		answer += "X";
		break;
	case OIS::KC_Y:
		answer += "Y";
		break;
	case OIS::KC_Z:
		answer += "Z";
		break;
	case OIS::KC_SPACE:
		answer += " ";
		break;
	case OIS::KC_BACK:
		answer.replace(answer.size() - 1, answer.size(), "");
		break;
	default:
		break;
		}
	}

	//	CEGUI::System::getSingleton().getDefaultGUIContext().injectKeyDown(arg->getKey());

	return true;
}

bool German::keyReleased(const OIS::KeyEvent& arg) {
	switch(arg.key) {
	case OIS::KC_RIGHT:
	case OIS::KC_D:
		runBase->setLoop(false);
		runTop->setLoop(false);
		//		runBase->setEnabled(false);
		//		runTop->setEnabled(false);
		//		m_direction.z = 0;
		mYaw = 0;
		break;
	case OIS::KC_LEFT:
	case OIS::KC_A:
		runBase->setLoop(false);
		runTop->setLoop(false);
		//		runBase->setEnabled(false);
		//		runTop->setEnabled(false);
		//		m_direction.z = 0;
		mYaw = 0;
		break;
	case OIS::KC_UP:
	case OIS::KC_W:
		runBase->setLoop(false);
		runTop->setLoop(false);
		runBase->setEnabled(false);
		runTop->setEnabled(false);
		m_direction = Ogre::Vector3::ZERO;
		break;
	case OIS::KC_DOWN:
	case OIS::KC_S:
		runBase->setLoop(false);
		runTop->setLoop(false);
		runBase->setEnabled(false);
		runTop->setEnabled(false);
		m_direction = Ogre::Vector3::ZERO;
		break;
	default:
		break;
	}
	return true;
}

// OIS::MouseListener
bool German::mouseMoved( const OIS::MouseEvent& evt ){
	//	if (evt.state.buttonDown(OIS::MB_Right))
	//	{
	//
	//		mCameraMan->injectMouseMove(evt);
	//	//	}
	CEGUI::System &sys = CEGUI::System::getSingleton();
	sys.getDefaultGUIContext().injectMouseMove(evt.state.X.rel, evt.state.Y.rel);
	//	// Scroll wheel.
	//if (evt.state.Z.rel)
	//  sys.getDefaultGUIContext().injectMouseWheelChange(evt.state.Z.rel / 120.0f);
	return true;
}

//-------------------------------------------------------------------------------------
bool German::mousePressed( const OIS::MouseEvent &arg, OIS::MouseButtonID id )
{
	//	CEGUI::System::getSingleton().getDefaultGUIContext().injectMouseButtonDown(convertButton(id));
	//	if(arg.state.buttonDown(OIS::MB_Right)){
	//		if(mPaused == false && !guiRoot->getChild("EndLabel")->isVisible()) {
	//			mPaused = true;
	//		}
	//		else if(mPaused == true && !guiRoot->getChild("EndLabel")->isVisible()){
	//			mPaused = false;
	//		}
	//		mShown = true;
	//	}
	return true;
}
//-------------------------------------------------------------------------------------
bool German::mouseReleased( const OIS::MouseEvent &arg, OIS::MouseButtonID id )
{
	//	CEGUI::System::getSingleton().getDefaultGUIContext().injectMouseButtonUp(convertButton(id));
	return true;
}

void German::endGame(void) {
	//	guiRoot->getChild("EndLabel")->show();
	//	mPaused = true;
}

//-------------------------------------------------------------------------------------
bool German::quit(const CEGUI::EventArgs &e)
{
	mShutDown = true;
	return true;
}

bool German::restart(const CEGUI::EventArgs &e)
{
	//	mSceneMgr->getSceneNode("SphereNode")->setPosition(0, 0, 0);
	//	mSceneMgr->getSceneNode("PaddleNode")->setPosition(0, -10, 140);
	//	mDirection = Vector3::ZERO;
	//	mBDirection = Vector3::ZERO;
	//	mStarted = false;
	//	if(guiRoot->getChild("EndLabel")->isVisible()) {
	//		mShutDown = false;
	//		mStarted = false;
	//		mPaused = false;
	//		mGameStarted = false;
	//		mShown = true;
	//		mEntered = false;
	//		numBlocks = 0;
	//		numBWanted = 10;
	//		ballsRem = 5;
	//		level = 1;
	//		currScore = 0;
	//		guiRoot->getChild("EndLabel")->hide();
	//	}
	return true;
}

bool German::name(const CEGUI::EventArgs &e)
{
	//	mEntered = true;
	return true;
}

bool German::queryResult(Ogre::MovableObject* first, //set before and reverse
		Ogre::MovableObject* second) {
	SceneNode * frst = first->getParentSceneNode();
	SceneNode * scnd = second->getParentSceneNode();

	SceneNode * snbd = mSceneMgr->getSceneNode("SinbadNode");
	SceneNode * hse = mSceneMgr->getSceneNode("HouseNode");
	SceneNode * pln = mSceneMgr->getSceneNode("PlaneNode");
	SceneNode * fsh = mSceneMgr->getSceneNode("fishNode");
	SceneNode * drgn = mSceneMgr->getSceneNode("dragonNode");
	SceneNode * gr = mSceneMgr->getEntity("GroundEntity")->getParentSceneNode();
	SceneNode * left = mSceneMgr->getEntity("LeftWallEntity")->getParentSceneNode();
	SceneNode * right = mSceneMgr->getEntity("RightWallEntity")->getParentSceneNode();
	//		SceneNode * top = mSceneMgr->getEntity("TopWallEntity")->getParentSceneNode();
	SceneNode * back = mSceneMgr->getEntity("FarWallEntity")->getParentSceneNode();
	SceneNode * close = mSceneMgr->getEntity("CloseWallEntity")->getParentSceneNode();

	//		if((frst == bll && scnd == pddle) || (frst == pddle && scnd == bll)) {
	//			Vector3 padPt(pddle->getPosition().x, pddle->getPosition().y, pddle->getPosition().z + 20);
	//			Vector3 ballPt(bll->getPosition());
	//			bll->setPosition(mOldPosition);
	//			//		ballPt.z = ballPt.z + 6;
	//			mBDirection = ballPt - padPt;
	//		}
	if((frst == snbd && scnd == hse) || (frst == hse && scnd == snbd)) {
		isGUI = true;
		guiRoot->getChild("HouseBox")->show();
	}
	if((frst == snbd && scnd == pln) || (frst == pln && scnd == snbd)) {
		isGUI = true;
		guiRoot->getChild("PlaneBox")->show();
	}
	if((frst == snbd && scnd == fsh) || (frst == fsh && scnd == snbd)) {
		isGUI = true;
		guiRoot->getChild("FishBox")->show();
	}
	if((frst == snbd && scnd == drgn) || (frst == fsh && scnd == drgn)) {
		isGUI = true;
		guiRoot->getChild("DragonBox")->show();
	}
	if((frst == snbd && scnd == left) || (frst == left && scnd == snbd)) {
					snbd->setPosition(Ogre::Vector3::ZERO);
		//			m_direction = mOldPosition;
	}
	if((frst == snbd && scnd == right) || (frst == right && scnd == snbd)) {
					snbd->setPosition(Ogre::Vector3::ZERO);
		//			m_direction = mOldPosition;
	}
	if((frst == snbd && scnd == back) || (frst == back && scnd == snbd)) {
					snbd->setPosition(Ogre::Vector3::ZERO);
		//			m_direction = mOldPosition;
	}
	if((frst == snbd && scnd == close) || (frst == close && scnd == snbd)) {
					snbd->setPosition(Ogre::Vector3::ZERO);
		//			m_direction = mOldPosition;
	}
	return true;
}
//---------------------------------------------------------------------------

#if OGRE_PLATFORM == OGRE_PLATFORM_WIN32
#define WIN32_LEAN_AND_MEAN
#include "windows.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if OGRE_PLATFORM == OGRE_PLATFORM_WIN32
INT WINAPI WinMain(HINSTANCE hInst, HINSTANCE, LPSTR strCmdLine, INT)
#else
int main(int argc, char *argv[])
#endif
{
	// Create application object
	German app;

	try {
		app.go();
	} catch(Ogre::Exception& e)  {
#if OGRE_PLATFORM == OGRE_PLATFORM_WIN32
		MessageBox(NULL, e.getFullDescription().c_str(), "An exception has occurred!", MB_OK | MB_ICONERROR | MB_TASKMODAL);
#else
		std::cerr << "An exception has occurred: " <<
				e.getFullDescription().c_str() << std::endl;
#endif
	}

	return 0;
}

#ifdef __cplusplus
}
#endif

//---------------------------------------------------------------------------




