/*
 * German.h
 *
 *  Created on: Apr 13, 2015
 *      Author: kohaje01
 */

#ifndef GERMAN_H_
#define GERMAN_H_


#include "BaseApplication.h"
#include <string>
#include <CEGUI/CEGUI.h>
#include <CEGUI/RendererModules/Ogre/Renderer.h>

//---------------------------------------------------------------------------

class German : public BaseApplication,
	public Ogre::IntersectionSceneQueryListener
{
public:
	//static const Ogre::uint32 SELECTABLE;
	static const Ogre::uint32 INTERSECTABLE;
    German(void);
    virtual ~German(void);

protected:
    CEGUI::OgreRenderer* mRenderer;
    virtual void createScene(void);
    virtual void createCamera(void);
    virtual void createFrameListener(void);
//    virtual void createViewports(void);
    virtual bool frameRenderingQueued(const Ogre::FrameEvent& evt);
    void setupGUI();
    virtual bool keyPressed(const OIS::KeyEvent &arg);
    virtual bool keyReleased(const OIS::KeyEvent &arg);
    virtual bool mouseMoved( const OIS::MouseEvent& evt );
    virtual bool mousePressed( const OIS::MouseEvent &arg, OIS::MouseButtonID id );
    virtual bool mouseReleased( const OIS::MouseEvent &arg, OIS::MouseButtonID id );
    virtual void endGame(void);

    bool quit(const CEGUI::EventArgs &e);
    bool restart(const CEGUI::EventArgs &e);
    bool name(const CEGUI::EventArgs &e);

    virtual bool queryResult(Ogre::MovableObject* first, Ogre::MovableObject* second);
    virtual bool queryResult(Ogre::MovableObject* movable, Ogre::SceneQuery::WorldFragment * fragment){
    	return true;
    }

private:

    Ogre::Vector3 mDirection;
    Ogre::Vector3 mBDirection;
    Ogre::SceneNode *mIntersected;
    Ogre::SceneNode *m_camNode;
    Ogre::RaySceneQuery *mRaySceneQuery;
    CEGUI::Window *guiRoot;
    Ogre::Entity* playerEnt;
    Ogre::SceneNode* sinbadNode;
    Ogre::AnimationState* runBase;
    Ogre::AnimationState* runTop;
    Ogre::Vector3 m_direction;

    //New stuff
    Ogre::IntersectionSceneQuery *mIntersectionQuery;
    Ogre::Vector3 mOldPosition;
    bool mShutDown;
    bool mPaused;
    bool mStarted;
    bool mGameStarted;
    bool mShown;
    bool mEntered;
    bool isGUI;
    bool isChosen;
    bool toHide;
    bool isOver;
    int numBlocks;
    int numBWanted;
    int ballsRem;
    int level;
    int currScore;
    int moveSpeed;
    int numObjects;
    Ogre::Degree mYaw;
    int yawDeg;
    Ogre::String answer;
};


#endif /* GERMAN_H_ */
