/*
 * BarrierBot.cpp
 *
 *  Created on: Apr 15, 2015
 *      Author: robijo04
 */
#include "BarrierBot.h"
#include "Constants.h"
#include "BBOrbiter.h"
OgreBulletCollisions::CollisionShape * BarrierBot::storedShellCollisionShape=0;
bool BarrierBot::shapeMade=false;
BarrierBot::BarrierBot(){
	alive=true;
	converted=false;
	timeMoving=0;
	numJumps=1;
	m_isInitialized=false;
	robotColor=ColourValue(1.0f,0.0f,1.0f,0.5f);
	materialName="PurpleCore";
	shellNode=0;
	shell=0;
	m_shellCollisionShape=0;
	m_shellRigidBody=0;
}
BarrierBot::~BarrierBot(){
	std::cout<<"Deleting Barrier Bot"<<std::endl;
	if(m_shellRigidBody)
		delete m_shellRigidBody;
	if(shellNode){
		shellNode->detachAllObjects();
		m_sceneMgr->destroyEntity(shell->getName());
		shellNode->getParentSceneNode()->removeChild(shellNode);
		m_sceneMgr->destroySceneNode(shellNode->getName());

	}
	std::cout<<"Shell Deleted"<<std::endl;


	if(m_shellCollisionShape)
		delete m_shellCollisionShape;
	std::cout<<"Physics Deleted if Present"<<std::endl;
}

void BarrierBot::init(Ogre::SceneManager *sceneMgr,Grid * grid, GameNode * currentNode, int id){

	if(m_isInitialized){
		return;
	}

	Robot::init(sceneMgr, grid, currentNode, id);
	m_core->setMaterialName(materialName);
	//m_coreLight->setDiffuseColour(0,255,255);
	//m_coreLight->setSpecularColour(0,255,255);
	//m_coreLight->setVisible(false);
	//Real radius=SCALE*.75;

	for(int i=0;i<2;i++){
		BBOrbiter * orbit= new BBOrbiter();

		orbit->init(sceneMgr, this, 3,Vector3(0, 0,90*i),i);
		m_orbiters.push_back(orbit);

	}
	BBOrbiter * orbit= new BBOrbiter();
	orbit->init(sceneMgr, this, 3,Vector3(0, 0,90),3);
	orbit->m_sceneNode->rotate(Vector3(1,0,0), Degree(90));
	m_orbiters.push_back(orbit);
	shell= m_sceneMgr->createEntity(name+"ShellPhysics", "BBShellSimple.mesh");
	shell->setMaterialName("GunMetal");


	if(!BarrierBot::shapeMade){
		Ogre::Matrix4 transform = Ogre::Matrix4::IDENTITY;
		transform.setScale(Vector3(m_sceneNode->_getDerivedScale()));
		OgreBulletCollisions::StaticMeshToShapeConverter makeShape(shell, transform);
		BarrierBot::setCollisionShape(makeShape.createConvexDecomposition());
	}
	//destabilize();
}
void BarrierBot::destabilize(){
	std::vector<GameNode*> neighbors=m_grid->getNeighbors(m_node->id);
	for(int i=0;i<neighbors.size();i++){
		GameNode* target=neighbors[i];
		Lightning *bolt=new Lightning();
		bolt->init(m_sceneMgr, m_node, target, this, i);
		bolts.push_back(bolt);
		if(target->occupants.size()>0){
			for(Robot* bot:target->occupants){
				bot->die();
			}
		}
	}
}
void BarrierBot::die(){
	if(alive){
		alive=false;
		clearBolts();
		for(Orbiter* orb:m_orbiters){
			delete orb;
		}
		std::cout<<"Deleted orbiters"<<std::endl;

		m_orbiters.clear();
		ParticleEmitter * em=plasmaCore->getEmitter(0);
		em->setEmissionRate(5);
		em->setTimeToLive(.3,.4);
		m_node->m_entity->setMaterialName("BlackCore");

		shellNode=m_sceneMgr->getRootSceneNode()->createChildSceneNode(name+"Shell_PhysicsNode");
		shellNode->scale(m_sceneNode->_getDerivedScale());
		shellNode->setPosition(m_sceneNode->_getDerivedPosition());
		shellNode->setOrientation(m_sceneNode->_getDerivedOrientation());
		shellNode->attachObject(shell);
		m_shellRigidBody = new OgreBulletDynamics::RigidBody(name + "_BODY", m_grid->m_world);

		m_shellRigidBody->setShape(shellNode, BarrierBot::storedShellCollisionShape,.5, .5, 1,shellNode->_getDerivedPosition(),shellNode->_getDerivedOrientation());
		changeState(STATIONARY);
	}

}
void  BarrierBot::setCollisionShape(OgreBulletCollisions::CollisionShape *shellCollisionShape)
{
	BarrierBot::storedShellCollisionShape=shellCollisionShape;
	BarrierBot::shapeMade=true;
}
