/*
 * BarrierBot.h
 *
 *  Created on: Apr 15, 2015
 *      Author: robijo04
 */

#ifndef BARRIERBOT_H_
#define BARRIERBOT_H_

#include <OgreSceneManager.h>
#include <OgreEntity.h>
#include <OgreFrameListener.h>
#include <OgreString.h>

#include <OgreBulletDynamicsRigidBody.h>
#include <deque>
#include <Shapes/OgreBulletCollisionsSphereShape.h>

#include "Robot.h"
using namespace Ogre;

class BarrierBot:public Robot{
public:
	BarrierBot();
	virtual ~BarrierBot();

	virtual void init(Ogre::SceneManager *sceneMgr,Grid * grid, GameNode * currentNode, int id);
	virtual void destabilize();
	virtual void die();

protected:
	OgreBulletCollisions::CollisionShape *m_shellCollisionShape;
	OgreBulletDynamics::RigidBody* m_shellRigidBody;
	SceneNode * shellNode;
	Entity * shell;
	static bool shapeMade;
	static OgreBulletCollisions::CollisionShape *storedShellCollisionShape;
	static void setCollisionShape(OgreBulletCollisions::CollisionShape *shellCollisionShape);


};


#endif /* BARRIERBOT_H_ */
