/*
 * Beam.cpp
 *
 *  Created on: Apr 21, 2015
 *      Author: robijo04
 */
#include "Beam.h"
Beam::Beam(){

}
Beam::~Beam(){
	mSceneNode->detachAllObjects();
	mSceneMgr->destroyBillboardChain(mBillboardChain->getName());
	mSceneMgr->destroySceneNode(mSceneNode->getName());
}

void Beam::init(SceneManager* sceneMgr, Robot *source,GameNode *end_node, ColourValue color)
{

	std::cout<<color<<std::endl;

	mSource=source;
	mStartNode=mSource->m_sceneNode;
	mStartPosition=mStartNode->getPosition();

	mEndGameNode=end_node;
	mEndNode=end_node->m_sceneNode;
	mEndPosition=mEndNode->getPosition();

	mName=source->name+"Beam";

	const Ogre::Vector3 distance = mEndPosition - mStartPosition;

	mBillboardChain = new Ogre::BillboardChain(mName);
	//mBillboardChain->setMaterialName("lightning"); //TODO make lightning material
	mSceneMgr=sceneMgr;
	mSceneNode = mSceneMgr->getRootSceneNode()->createChildSceneNode(mName+"Node");
	mSceneNode->attachObject(mBillboardChain);

	//mBillboardChain->setUseTextureCoords(true);
	mBillboardChain->setUseVertexColours(true);

	Ogre::Vector3 element_position = mStartPosition;
	Ogre::Real element_width = 2;
	Ogre::Real texcoord = 0;
	Ogre::Vector3 step = distance/19;

	for (int i = 0; i<20; ++i)
	{
		texcoord = i;
		mBillboardChain->addChainElement(0, Ogre::BillboardChain::Element(element_position,element_width,texcoord, color, Quaternion(0,0,0,0)));
		element_position += step;
	}

}
void Beam::update()
{
	mStartPosition = mStartNode->getPosition();
	mEndPosition = mEndNode->getPosition();

	const Ogre::Vector3 distance = mEndPosition - mStartPosition;

	// update position
	Ogre::Vector3 element_position = mStartPosition;
	Ogre::Vector3 step = distance/19;
	for (int i = 0; i<20; ++i)
	{
		Ogre::BillboardChain::Element element = mBillboardChain->getChainElement(0,i);
		element.position = step.normalisedCopy() + element_position;
		mBillboardChain->updateChainElement(0,i,element);
		element_position += step;
	}

}
