/*
 * Beam.h
 *
 *  Created on: Apr 21, 2015
 *      Author: robijo04
 */

#ifndef Beam_H_
#define Beam_H_


#include <OgreSceneManager.h>
#include <OgreEntity.h>
#include <OgreFrameListener.h>
#include <OgreString.h>

#include "Constants.h"
using namespace Ogre;

class Beam{
public:
	Beam();
	virtual ~Beam();
	virtual void init(SceneManager* mSceneMgr, Robot * source, GameNode * end, ColourValue color);
	virtual void update();
	String mName;
protected:
	Robot *  mSource;
	GameNode * mEndGameNode;
	SceneNode * mStartNode;
	SceneNode * mEndNode;
	SceneManager * mSceneMgr;
	SceneNode * mSceneNode;
	Vector3 mStartPosition;
	Vector3 mEndPosition;
	BillboardChain * mBillboardChain;

	ColourValue color;

};


#endif /* Beam_H_ */
