/*
 * Constants.h
 *
 *  Created on: Apr 15, 2015
 *      Author: robijo04
 */

#ifndef CONSTANTS_H_
#define CONSTANTS_H_
#include "Grid.h"
#include "Orbiter.h"
#include "Robot.h"
#include "GameNode.h"
#include "Beam.h"
#include "Lightning.h"



using namespace Ogre;
const Real SCALE=10;
const Real NODE_DISTANCE=100;
const Real PI = 3.14159265358979323846;
const Ogre::uint32 NODE_FLAG=1;
const int PLAYER_SELECTING=0;
const int PLAYER_MOVING=1;
const int BOTS_MOVING=2;
const int ANIMATION=3;

const int STATIONARY=0;
const int MOVING=1;
const int REV_UP=2;
const int REV_DOWN=3;
const int W_REV_UP=4;
const int W_REV_DOWN=5;

const Real ANIMATION_TIME=2;
const Real STEP_TIME=5;


const Vector3 RIGHT=Vector3(1,0,0);
const Vector3 RIGHT_DOWN=Vector3(1,-1,0);
const Vector3 RIGHT_UP=Vector3(1,1,0);
const Vector3 RIGHT_IN=Vector3(1,0,-1);
const Vector3 RIGHT_OUT=Vector3(1,0,1);
const Vector3 RIGHT_DOWN_IN=Vector3(1,-1,-1);
const Vector3 RIGHT_DOWN_OUT=Vector3(1,-1,1);
const Vector3 RIGHT_UP_IN=Vector3(1,1,-1);
const Vector3 RIGHT_UP_OUT=Vector3(1,1,1);

const Vector3 LEFT=Vector3(-1,0,0);
const Vector3 LEFT_DOWN=Vector3(-1,-1,0);
const Vector3 LEFT_UP=Vector3(-1,1,0);
const Vector3 LEFT_IN=Vector3(-1,0,-1);
const Vector3 LEFT_OUT=Vector3(-1,0,1);
const Vector3 LEFT_DOWN_IN=Vector3(-1,-1,-1);
const Vector3 LEFT_DOWN_OUT=Vector3(-1,-1,1);
const Vector3 LEFT_UP_OUT=Vector3(-1,1,1);
const Vector3 LEFT_UP_IN=Vector3(-1,1,-1);

const Vector3 DOWN=Vector3(0,-1,0);
const Vector3 DOWN_IN=Vector3(0,-1,-1);
const Vector3 DOWN_OUT=Vector3(0,-1,1);

const Vector3 UP=Vector3(0,1,0);
const Vector3 UP_IN=Vector3(0,1,-1);
const Vector3 UP_OUT=Vector3(0,1,1);

const Vector3 JUST_IN=Vector3(0,0,-1);
const Vector3 JUST_OUT=Vector3(0,0,1);
//const Vector3 IN=Vector3(0,0,-1);
//const Vector3 OUT=Vector3(0,0,1);


const std::vector<Vector3> DIRECTIONS={RIGHT,RIGHT_DOWN, RIGHT_UP,RIGHT_IN,RIGHT_OUT,RIGHT_DOWN_IN,RIGHT_DOWN_OUT,RIGHT_UP_IN,RIGHT_UP_OUT,LEFT,LEFT_DOWN,LEFT_UP,LEFT_IN,LEFT_OUT,LEFT_DOWN_IN,LEFT_DOWN_OUT,LEFT_UP_OUT,LEFT_UP_IN,DOWN,DOWN_IN,DOWN_OUT,UP,UP_IN,UP_OUT,JUST_IN,JUST_OUT};


#endif /* CONSTANTS_H_ */
