/*
 * DDDLBOrbiter.cpp
 *
 *  Created on: Feb 23, 2015
 *      Author: robijo04
 */
#include "DLBOrbiter.h"
#include "Constants.h"
#include "Subcore.h"
DLBOrbiter::DLBOrbiter() {
	m_isInitialized=false;
	mesh="DLBArmilliarySphere.mesh";
	orbits=false;
	rotates=true;
	targetDirection=Vector3(0,0,0);
}

DLBOrbiter::~DLBOrbiter(void) {
	for(Subcore * sc:m_subcores){
			delete sc;
		}
		m_subcores.clear();
}
void DLBOrbiter::init(SceneManager * sceneMgr, Robot * parent,
		Real tanSpeed,  Vector3 initialAngle, int id ){
	std::cout<<"Init DLBOrbiter "<<std::endl;


	if(m_isInitialized)return;

	Orbiter::init( sceneMgr, parent,  1,tanSpeed, initialAngle, Vector3(0,1,0), Vector3 (0,0,0), Vector3 (0,0,0), Vector3 (0,0,0),parent->m_grid->m_world, id );
	m_entity->setMaterialName("GunMetal");
	m_sceneNode->scale(1.1,1.1,1.1);

	Subcore* subcore=new Subcore();
	subcore->init(m_sceneMgr,parent, m_sceneNode, Vector3(0,-1.2,0),Vector3(.3,.3,.3),0);
	m_subcores.push_back(subcore);

	subcore=new Subcore();
	subcore->init(m_sceneMgr,parent, m_sceneNode,Vector3(0,1.2,0), Vector3(.3,.3,.3),1);
	m_subcores.push_back(subcore);

	subcore=new Subcore();
	subcore->init(m_sceneMgr,parent, m_sceneNode, Vector3(1.2,0,0),Vector3(.3,.3,.3),2);
	m_subcores.push_back(subcore);

	subcore=new Subcore();
	subcore->init(m_sceneMgr,parent, m_sceneNode,Vector3(-1.2,0,0), Vector3(.3,.3,.3),3);
	m_subcores.push_back(subcore);

	subcore=new Subcore();
	subcore->init(m_sceneMgr,parent, m_sceneNode, Vector3(0,0,-1.2),Vector3(.3,.3,.3),4);
	m_subcores.push_back(subcore);

	subcore=new Subcore();
	subcore->init(m_sceneMgr,parent, m_sceneNode,Vector3(0,0,1.2), Vector3(.3,.3,.3),5);
	m_subcores.push_back(subcore);

	std::cout<<"subcores made "<<std::endl;

}

void DLBOrbiter::die(){
	if(alive){
		printInfo();
		std::cout<<"is about To die"<<std::endl;

		SceneNode * newSceneNode=m_sceneMgr->getRootSceneNode()->createChildSceneNode(name+"_PhysicsNode");

		newSceneNode->scale(m_sceneNode->_getDerivedScale());
		newSceneNode->setPosition(m_sceneNode->_getDerivedPosition());
		newSceneNode->setOrientation(m_sceneNode->_getDerivedOrientation());
		Entity * newEnt= m_sceneMgr->createEntity(name+"Physics", mesh);
		newEnt->setMaterialName(materialName);
		newSceneNode->attachObject(newEnt);
		for(Subcore * sc:m_subcores){
			sc->changeParentNode(newSceneNode);
		}

		m_sceneNode->detachAllObjects();
		m_sceneMgr->destroyEntity(m_entity->getName());
		m_sceneMgr->destroySceneNode(m_sceneNode->getName());
		m_entity=newEnt;
		m_sceneNode=newSceneNode;

		m_rigidBody = new OgreBulletDynamics::RigidBody(name + "_BODY", m_world);
		std::cout<<m_collisionShape<<std::endl;
		m_rigidBody->setShape(m_sceneNode, m_collisionShape,.5, .5, 1,m_sceneNode->_getDerivedPosition(),m_sceneNode->_getDerivedOrientation());

		if(rotates){
			m_rigidBody->getBulletRigidBody()->setAngularVelocity(OgreBulletCollisions::OgreBtConverter::to(
					m_rotationSpeed*rotationDirection));
		}

		m_rigidBody->setDamping(0.5, 0.5); //linear and rotational
		alive=false;
		printInfo();
		std::cout<<"Is now Dead"<<std::endl;

	}
}

OgreBulletCollisions::CollisionShape * DLBOrbiter::storedOrbiterCollisionShape=0;
bool DLBOrbiter::shapeMade=false;
void  DLBOrbiter::setOrbiterCollisionShape(OgreBulletCollisions::CollisionShape * orbiterCollisionShape)
{
	DLBOrbiter::storedOrbiterCollisionShape=orbiterCollisionShape;
	DLBOrbiter::shapeMade=true;
}
OgreBulletCollisions::CollisionShape * DLBOrbiter::getCollisionShape(){
	if(!DLBOrbiter::shapeMade){
		Ogre::Matrix4 transform = Ogre::Matrix4::IDENTITY;
		transform.setScale(Vector3(m_sceneNode->_getDerivedScale()*.75));
		OgreBulletCollisions::StaticMeshToShapeConverter makeShape(m_entity, transform);
		setOrbiterCollisionShape( makeShape.createConvexDecomposition());
	}
	return DLBOrbiter::storedOrbiterCollisionShape;
}
