/*
 * DDLBOrbiter.h
 *
 *  Created on: Apr 15, 2015
 *      Author: robijo04
 */

#ifndef DLBORBITER_H_
#define DLBORBITER_H_
#include <OgreSceneManager.h>
#include <OgreEntity.h>
#include <OgreFrameListener.h>
#include <OgreString.h>

#include <OgreBulletDynamicsRigidBody.h>
#include <deque>
#include <Shapes/OgreBulletCollisionsSphereShape.h>
#include "Orbiter.h"

class Robot;
class Grid;
class Subcore;


using namespace Ogre;
class DLBOrbiter: public Orbiter{
public:
	DLBOrbiter();
	virtual ~DLBOrbiter();
	virtual void init(SceneManager * sceneMgr, Robot * parent, Real tanSpeed,  Vector3 initialAngle, int id );
	Vector3 targetDirection;
	std::vector<Subcore *> m_subcores;
	virtual void die();
protected:
	static OgreBulletCollisions::CollisionShape * storedOrbiterCollisionShape;
	static void setOrbiterCollisionShape(OgreBulletCollisions::CollisionShape * orbiterCollisionShape);
	static bool shapeMade;
	virtual OgreBulletCollisions::CollisionShape * getCollisionShape();
};

#endif /* DLBORBITER_H_ */
