/*
 * DemonLaserBot.cpp
 *
 *  Created on: Apr 15, 2015
 *      Author: robijo04
 */
#include "DemonLaserBot.h"
#include "Constants.h"
#include "DLBOrbiter.h"

DemonLaserBot::DemonLaserBot(){
	alive=true;
	converted=false;
	timeMoving=0;
	numJumps=1;
	m_isInitialized=false;
	robotColor=ColourValue(0.0f,1.0f,0.0f,0.5f);
	materialName="GreenCore";
}
DemonLaserBot::~DemonLaserBot(){

}

void DemonLaserBot::init(Ogre::SceneManager *sceneMgr,Grid * grid, GameNode * currentNode, int id){

	if(m_isInitialized){
		return;
	}

	Robot::init(sceneMgr, grid, currentNode, id);
	m_core->setMaterialName(materialName);
	//m_coreLight->setDiffuseColour(0,255,255);
	//m_coreLight->setSpecularColour(0,255,255);
	//m_coreLight->setVisible(false);

	DLBOrbiter * orbit= new DLBOrbiter();
	orbit->init(sceneMgr, this, 3,Vector3(0, 0,90),0);
	m_orbiters.push_back(orbit);
}
void DemonLaserBot::destabilize(){
	std::cout<<name<<" is firing it's beam"<<std::endl;
	Vector3 relPos=m_grid->IDToVector(m_node->id);
	std::vector<GameNode*> targets;

	int size=m_grid->size;
	bool done=false;
	int boltCount=0;
	GameNode* source=m_node;
	while(!done){
		relPos+=targetDirection;
		std::cout<<"relPos= "<<relPos<<std::endl;
		int x=relPos.x;
		int y=relPos.y;
		int z= relPos.z;
		if(x>=0&&x<size&&y>=0&&y<size&&z>=0&&z<size){

			GameNode* target=m_grid->nodes[m_grid->VectorToID(relPos)];
			std::cout<<"target->id= "<<target->id<<std::endl;
			Lightning *bolt=new Lightning();
			bolt->init(m_sceneMgr, source, target, this, boltCount);
			bolt->jitter=5;
			bolts.push_back(bolt);
			boltCount++;
			source=target;
			if(target->occupants.size()>0){
				for(Robot* bot:target->occupants){
					bot->die();
				}
				done=true;
			}
		}else{
			done=true;
		}

	}
	bolts[0]->jitterStart=3;
}
void DemonLaserBot::moving(const Ogre::FrameEvent& evt){
	if(timeInState>=moveTime){

		m_position=destination;

		m_sceneNode->setPosition(destination);
		std::cout<<"Finished Moving Here"<<std::endl;
		//std::cout<<moveBeam->mName<<std::endl;
		delete moveBeam;
		moveBeam=0;
		std::cout<<jumpsRemaining<<std::endl;
		m_node->addRobot(this);
		if(m_node->occupants.size()>1){
			die();
			changeState(STATIONARY);
			m_node->occupants[0]->die();
		}else if(jumpsRemaining==0){


			changeState(REV_DOWN);
			bool done=false;
			Vector3 relPos=m_grid->IDToVector(m_node->id);
			int size=m_grid->size;
			GameNode* node=m_grid->dirToPlayer(m_node);
			Vector3 target=m_grid->IDToVector(node->id);
			targetDirection=target-relPos;

			Vector3 mDestination = m_grid->nodes[m_grid->VectorToID(target)]->m_position;                    // mDestination is the next location
			Vector3 mDirection = mDestination - m_position;     // B-A = A->B (see vector questions above)
			Vector3 src = m_sceneNode->getOrientation() * Vector3::UNIT_X;      // Orientation from initial direction
			src.normalise();
			Real mDistance = mDirection.normalise( );                     // Both vectors modified so renormalize them

			if ((1.0f + src.dotProduct(mDirection)) < 0.0001f)            // Work around 180 degree quaternion rotation quirk
			{
				//m_sceneNode->yaw(Degree(180));
			}
			else
			{
				Quaternion quat = src.getRotationTo(mDirection);

				mRotating=true;
				mRotFactor = 1.0f / ANIMATION_TIME;
				mOrientSrc = m_sceneNode->getOrientation();
				mOrientDest = quat * mOrientSrc;           // We want dest orientation, not a relative rotation (quat)
				mRotProgress = 0;

			}

			jumpsRemaining=numJumps;

		}else if(alive){
			move(m_grid->dirToPlayer(m_node));
			changeState(MOVING);
		}

	}else{
		m_position=m_position+m_direction*m_speed*evt.timeSinceLastFrame;
		m_sceneNode->setPosition(m_position);

		moveBeam->update();
	}
}
void DemonLaserBot::revDown(const Ogre::FrameEvent& evt){
	if(m_node->occupants.size()>1){
		die();
		changeState(STATIONARY);
	}
	else if(timeInState>=ANIMATION_TIME){
		changeState(STATIONARY);
		for(Orbiter* orb:m_orbiters){
			orb->resetSpeed();
		}

		destabilize();
	}else{
		for(Orbiter* orb:m_orbiters){
			orb->accelerate(-.2/ANIMATION_TIME);
		}

		if(mRotating)                                // Process timed rotation
		{
			mRotProgress += mRotFactor*evt.timeSinceLastFrame;
			if(mRotProgress>1)
			{
				mRotating = false;
			}
			else
			{
				Quaternion delta = Quaternion::Slerp(mRotProgress, mOrientSrc, mOrientDest, true);
				m_sceneNode->setOrientation(delta);
			}
		}

	}

}
void DemonLaserBot::tilt(Vector3 rotations){
	m_sceneNode->rotate(Vector3(1,0,0),Angle(rotations.x));
	m_sceneNode->rotate(Vector3(0,1,0),Angle(rotations.y));
	m_sceneNode->rotate(Vector3(0,0,1),Angle(rotations.z));
	currentRotations+=rotations;
}
void DemonLaserBot::getTargetRotations(Vector3 targetDirection){

	targetRotations=targetDirection;
	int totalDirections=0;
	if(targetRotations.x!=0){
		targetRotations.x*=45;
		totalDirections++;
	}if(targetRotations.y!=0){
		targetRotations.y*=45;
		totalDirections++;
	}
	if(targetRotations.z!=0){
		targetRotations.z*=45;
		totalDirections++;
	}
	if(totalDirections==1){
		targetRotations*=2;
	}
}
