/*
 * Laser.h
 *
 *  Created on: Apr 15, 2015
 *      Author: robijo04
 */

#ifndef DEMONLASERBOT_H_
#define DEMONLASERBOT_H_

#include <OgreSceneManager.h>
#include <OgreEntity.h>
#include <OgreFrameListener.h>
#include <OgreString.h>

#include <OgreBulletDynamicsRigidBody.h>
#include <deque>
#include <Shapes/OgreBulletCollisionsSphereShape.h>

#include "Robot.h"
using namespace Ogre;

class DemonLaserBot:public Robot{
public:
	DemonLaserBot();
	virtual ~DemonLaserBot();

	virtual void init(Ogre::SceneManager *sceneMgr,Grid * grid, GameNode * currentNode, int id);
	Vector3 targetDirection;
	Vector3 targetRotations;
	Vector3 currentRotations;
	Vector3 rotationRate;

	Quaternion mOrientSrc;               // Initial orientation
	Quaternion mOrientDest;              // Destination orientation
	Real mRotProgress;                   // How far we've interpolated
	Real mRotFactor;                     // Interpolation step
	bool mRotating;


	virtual void tilt(Vector3 rotations);
	virtual void getTargetRotations(Vector3 targetDirection);
protected:
	virtual void destabilize();
	virtual void moving(const Ogre::FrameEvent& evt);
	virtual void revDown(const Ogre::FrameEvent& evt);


};


#endif /* DEMONLASERBOT_H_ */
