/*
 * FastBot.cpp
 *
 *  Created on: Apr 15, 2015
 *      Author: robijo04
 */
#include "FastBot.h"
#include "Constants.h"
#include "FBOrbiter.h"

FastBot::FastBot(){
	alive=true;
	converted=false;
	timeMoving=0;
	numJumps=2;
	jumpsRemaining=numJumps;
	m_isInitialized=false;
	robotColor=ColourValue(1.0f,1.0f,0.0f,0.5f);
	materialName="YellowCore";
}
FastBot::~FastBot(){

}

void FastBot::init(Ogre::SceneManager *sceneMgr,Grid * grid, GameNode * currentNode, int id){

	if(m_isInitialized){
		return;
	}

	Robot::init(sceneMgr, grid, currentNode, id);
	m_core->setMaterialName(materialName);


	std::vector<Vector3> positions={Vector3 (0,1,0),Vector3 (0,-1,0), Vector3 (0,0,1),Vector3 (0,0,-1), Vector3 (1,0,1),Vector3 (1,0,-1), Vector3 (-1,0,-1),Vector3 (-1,0,1)};
	std::vector<Vector3> orbitDirections= {Vector3 (0,0,1),Vector3 (0,0,-1), Vector3 (0,-1,0),Vector3 (0,1,0), Vector3 (-1,0,1),Vector3 (1,0,1), Vector3 (1,0,-1),Vector3 (-1,0,-1)};
	Vector3 rotDir (0,1,0);
	std::vector<Vector3> initialAngles={Vector3 (0,0,0),Vector3 (0,0,0), Vector3 (90,0,0),Vector3 (90,0,0), Vector3 (90,0,0),Vector3 (90,0,0), Vector3 (90,0,0),Vector3 (90,0,0)};
	std::vector<Vector3> initialAngles2={Vector3 (0,0,0),Vector3 (0,0,0), Vector3 (0,0,0),Vector3 (0,0,0), Vector3 (0,1,0),Vector3 (0,-1,0), Vector3 (0,1,0),Vector3 (0,-1,0)};

	for(int i=0;i<2;i++){
		for (int j=0; j<4;j++){
			int index=j+i*4;
			FBOrbiter * orbit= new FBOrbiter();
			orbit->init(sceneMgr, this, 2, 3, initialAngles[index], rotDir, orbitDirections[index], positions[index], orbitDirections[index],m_grid->m_world,index );
			orbit->m_sceneNode->rotate(initialAngles2[index],Degree(45), Node::TS_PARENT);
			m_orbiters.push_back(orbit);
		}


	}

}

