/*
 * Node.cpp
 *
 *  Created on: Apr 15, 2015
 *      Author: robijo04
 */
#include "GameNode.h"
#include "Constants.h"
using namespace Ogre;

OgreBulletCollisions::CollisionShape * GameNode::storedNodeCollisionShape=0;
bool GameNode::shapeMade=false;
GameNode::GameNode(){
	m_isInitialized=false;
}
GameNode::~GameNode(){


}

void GameNode::addRobot(Robot * bot){
	occupants.push_back(bot);
	std::cout<<bot->materialName<<" occupants: "<<occupants.size()<<std::endl;
	if(occupants.size()==1){
		//materialName=materialName;
		m_entity->setMaterialName(bot->materialName);
		std::cout<<bot->materialName<<std::endl;
	}
	isOccupied=true;
	isSafe=false;
}
void GameNode::removeRobot(Robot * bot){
	if(occupants.size()==1){
		occupants.pop_back();
		m_entity->setMaterialName("WireWhiteCore");
		isOccupied=false;
	}else{
		//for loop to remove
	}
}
void GameNode::destabilize(){
	isStable=false;
}

void GameNode::init(Ogre::SceneManager *sceneMgr,Grid * grid, Vector3 position, OgreBulletDynamics::DynamicsWorld* world, int id){

	//don't initialize more than once
	if(m_isInitialized)
		return;
	m_world=world;
	m_sceneMgr = sceneMgr;
	m_isInitialized = true;
	Ogre::String number = Ogre::StringConverter::toString(id);
	Ogre::String name="GameNode"+number;

	//set up the entity
	m_entity = m_sceneMgr->createEntity(name, "SimpleNode.mesh");

	//set up the scene node
	m_sceneNode = m_sceneMgr->getRootSceneNode()->createChildSceneNode(name + "Node");
	m_sceneNode->attachObject(m_entity);
	m_sceneNode->scale(SCALE*1.1,SCALE*1.1,SCALE*1.1);
	//set the position
	m_position = position;
	m_sceneNode->setPosition(m_position);



	//scale to HEIGHT
	Ogre::AxisAlignedBox box = m_entity->getBoundingBox();
	Ogre::Vector3 boxSize = box.getSize();
	isStable=true;
	isOccupied=false;
	m_grid=grid;

	if( !GameNode::shapeMade){
		Ogre::AxisAlignedBox bound = m_entity->getWorldBoundingBox();

		Ogre::Vector3 desiredSize = (bound.getMaximum() - bound.getMinimum());

		Ogre::Matrix4 transform= Ogre::Matrix4::IDENTITY;
		transform.setScale(desiredSize*m_sceneNode->_getDerivedScale());
		OgreBulletCollisions::StaticMeshToShapeConverter makeShape(m_entity, transform);
		OgreBulletCollisions::CollisionShape *shape = makeShape.createConvexDecomposition();
		GameNode::setCollisionShape(shape);
	}
	OgreBulletDynamics::RigidBody *body = new OgreBulletDynamics::RigidBody(m_sceneNode->getName(), m_world);
	body->setStaticShape(GameNode::storedNodeCollisionShape, 0.1, 0.8,m_sceneNode->_getDerivedPosition());
	//body->setShape(m_sceneNode,shape, 0.1, 0.8,1000, m_sceneNode->_getDerivedPosition());

	//nodeCollisionShape;
	//nodeRigidBody;
	this->id=id;
	m_isInitialized=true;
}
Vector3 GameNode::getPosition(){
	return m_position;
}
void  GameNode::setCollisionShape(OgreBulletCollisions::CollisionShape *nodeCollisionShape)
{
	GameNode::storedNodeCollisionShape=nodeCollisionShape;
	GameNode::shapeMade=true;
}
void  GameNode::unsetCollisionShape()
{
	GameNode::shapeMade=false;
	delete GameNode::storedNodeCollisionShape;
	GameNode::storedNodeCollisionShape=0;
}

