/*
 * GameNode.h
 *
 *  Created on: Apr 15, 2015
 *      Author: robijo04
 */

#ifndef GAMENODE_H_
#define GAMENODE_H_

#include <OgreSceneManager.h>
#include <OgreEntity.h>
#include <OgreFrameListener.h>
#include <OgreString.h>
#include "Robot.h"
#include "Grid.h"
#include <OgreBulletDynamicsRigidBody.h>
#include <deque>
#include <Shapes/OgreBulletCollisionsSphereShape.h>
#include <Utils/OgreBulletCollisionsMeshToShapeConverter.h>
#include <Shapes/OgreBulletCollisionsCompoundShape.h>
using namespace Ogre;

class GameNode{
public:
	GameNode();
	virtual ~GameNode();
	Entity* m_entity;
	SceneNode* m_sceneNode;
	SceneManager* m_sceneMgr;
	OgreBulletDynamics::DynamicsWorld* m_world;
	bool m_isInitialized;
	Grid* m_grid;
	std::vector<Robot *> occupants;
	bool isOccupied;
	bool isStable;
	bool isSafe;
	bool shutDown;
	static bool shapeMade;
	//std::vector<GameNode *> neighbors;
	Vector3 m_position;
	virtual void addRobot(Robot * bot);
	virtual void removeRobot(Robot * bot);
	virtual void destabilize();
	virtual Vector3 getPosition();
	OgreBulletCollisions::CollisionShape *nodeCollisionShape;
	static OgreBulletCollisions::CollisionShape *storedNodeCollisionShape;
	static void setCollisionShape(OgreBulletCollisions::CollisionShape *nodeCollisionShape);
	static void unsetCollisionShape();
	OgreBulletDynamics::RigidBody* nodeRigidBody;
	int id;
	virtual void init(Ogre::SceneManager *sceneMgr,Grid * grid, Vector3 position, OgreBulletDynamics::DynamicsWorld* world, int id);
	//static
};


#endif /* GAMENODE_H_ */
