/*
 * Grid.cpp
 *
 *  Created on: Apr 15, 2015
 *      Author: robijo04
 */





#include "Constants.h"

Grid::Grid(){

}
Grid::~Grid(){

}

std::vector<GameNode*> Grid::getNeighbors(int nodeId){
	std::vector<GameNode*> neighbors;
	if(nodeId>=0&&nodeId<currentId){
		Vector3 relPos=IDToVector(nodeId);
		for(int dx=-1;dx<2;dx++){
			for(int dy=-1;dy<2;dy++){
				for(int dz=-1;dz<2;dz++){
					if(dz!=0||dy!=0||dx!=0){
						int x=relPos.x+dx;
						int y=relPos.y+dy;
						int z=relPos.z+dz;
						if(x>=0&&x<size&&y>=0&&y<size&&z>=0&&z<size){
							Vector3 neighborPos= Vector3(x,y,z);
							int neighborID=VectorToID(neighborPos);
							if(neighborID>=0&&neighborID<currentId){
								neighbors.push_back(nodes[neighborID]);
							}
						}
					}
				}
			}
		}
		return neighbors;
	}else{
		return neighbors;
	}

}
void Grid::init(Ogre::SceneManager *sceneMgr, OgreBulletDynamics::DynamicsWorld* world, int size){
	this->size=size;
	currentId=0;
	m_world=world;
	for (int x=0;x<size;x++){
		for (int y=0;y<size;y++){
			for(int z=0;z<size;z++){
				Vector3 pos(x*NODE_DISTANCE,y*NODE_DISTANCE,z*NODE_DISTANCE);
				positions.push_back(pos);
				GameNode * gm=new GameNode();
				gm->init(sceneMgr, this,pos,m_world,currentId);

				nodes.push_back(gm);
				currentId++;
				//std::cout<<"Made Node ID "<<gm->id<<" Pos "<<pos<< "relPos "<<"IDToVector "<<IDToVector(gm->id)<< "And back again "<<VectorToID(IDToVector(gm->id))<<std::endl;

			}
		}
	}

}
int Grid::VectorToID(Vector3 relPos){
	if(relPos.x<0||relPos.y<0||relPos.z<0) return -1;
	return relPos.x*size*size+relPos.y*size+relPos.z;
	//25+5+1
}
Vector3 Grid::IDToVector(int nodeId){ //31
	int z=nodeId%(size); //31%5=1
	int y=(nodeId-z)/size%size; //30/5=6%5=1
	int x=(nodeId-z-y)/(size*size); // 25/25=1;

	return Vector3(x,y,z);
}

GameNode * Grid::dirToPlayer(GameNode* position){

	Vector3 playerPosition=playerNode->m_position;
	std::vector<GameNode*> neighbors=getNeighbors(position->id);
	GameNode* currentTarget=neighbors[0];
	Vector3 currentPosition=currentTarget->m_position;
	GameNode* target=neighbors[0];
	Real shortestDist=currentPosition.squaredDistance(playerPosition);

	for(int i=0; i<neighbors.size();i++){
		GameNode* currentTarget=neighbors[i];
		Vector3 currentPosition=currentTarget->m_position;
		Real dist=currentPosition.squaredDistance(playerPosition);
		if(dist<shortestDist){
			target=currentTarget;
			shortestDist=dist;
		}
	}
	return target;
}
void Grid::clearMarkers(){
	for(GameNode* gm:nodes){
		if(!gm->isOccupied||gm->occupants.size()<1){
			gm->isSafe=true;
			gm->isOccupied=false;
			gm->m_entity->setMaterialName("WireWhiteCore");
		}
	}
}
void Grid::setMarkers(){
	for(GameNode* gm:nodes){
		if(gm->occupants.size()>=2){
			gm->isSafe=false;
			gm->isOccupied=true;
		}
		else if(gm->occupants.size()>0){
			gm->isOccupied=true;
			int range=gm->occupants[0]->numJumps;
			Vector3 relPos=IDToVector(gm->id);
			for(int dx=-1*range;dx<=1*range;dx++){
				for(int dy=-1*range;dy<=1*range;dy++){
					for(int dz=-1*range;dz<=1*range;dz++){
						if(dz!=0||dy!=0||dx!=0){
							Vector3 neighborPos= Vector3(relPos.x+dx,relPos.y+dy,relPos.z+dz);
							int neighborID=VectorToID(neighborPos);
							if(neighborID>=0&&neighborID<currentId){
								nodes[neighborID]->isSafe=false;
							}
						}
					}
				}
			}
		}
	}
}
void Grid::markAround(int nodeId, int range){
	Vector3 relPos=IDToVector(nodeId);
	std::cout<<"Node ID "<<nodeId<<" relPos "<<relPos<<std::endl;
	for(int dx=-1*range;dx<=range;dx++){
		for(int dy=-1*range;dy<=range;dy++){
			for(int dz=-1*range;dz<=range;dz++){
				Vector3 neighborPos= Vector3(relPos.x+dx,relPos.y+dy,relPos.z+dz);
				int neighborID=VectorToID(neighborPos);

				if(neighborID>=0&&neighborID<currentId){
					nodes[neighborID]->isSafe=false;
					//std::cout<<"Unsafe: "<<neighborID<<" at pos: "<<neighborPos<<" id to vector "<<IDToVector(neighborID)<<std::endl;
				}

			}
		}
	}
}
std::vector<GameNode*> Grid::getSafeNodes(){
	std::vector<GameNode*> safeNodes;
	for(GameNode* gm:nodes){
		if(gm->isSafe){
			safeNodes.push_back(gm);
			std::cout<<"Safe: "<<gm->id<<std::endl;
		}
	}
	return safeNodes;


}



