/*
 * Robot.h
 *
 *  Created on: Apr 15, 2015
 *      Author: robijo04
 */

#ifndef GRID_H_
#define GRID_H_

#include <OgreSceneManager.h>
#include <OgreEntity.h>
#include <OgreFrameListener.h>
#include <OgreString.h>

#include <OgreBulletDynamicsRigidBody.h>
#include <deque>
#include <Shapes/OgreBulletCollisionsSphereShape.h>

class Orbiter;
class GameNode;

using namespace Ogre;

class Grid{
public:
	Grid();
	virtual ~Grid();
	std::vector<GameNode*> nodes;
	GameNode* playerNode;
	OgreBulletDynamics::DynamicsWorld* m_world;
	int size;
	std::vector<Vector3> positions;
	std::vector<Vector3> relPositions;
	int currentId;
	virtual std::vector<GameNode*> getNeighbors(int nodeId);
	virtual void init(Ogre::SceneManager *sceneMgr,OgreBulletDynamics::DynamicsWorld* world, int size);
	virtual int VectorToID(Vector3 relPos);
	virtual Vector3 IDToVector(int nodeId);
	virtual GameNode * dirToPlayer(GameNode* position);
	virtual void clearMarkers();
	virtual void setMarkers();
	virtual std::vector<GameNode*> getSafeNodes();
	void markAround(int nodeId, int range);
};


#endif /* GRID_H_ */
