/*
 * LBOrbiter.cpp
 *
 *  Created on: Feb 23, 2015
 *      Author: robijo04
 */
#include "LBOrbiter.h"
#include "Constants.h"
#include "Subcore.h"
LBOrbiter::LBOrbiter() {
	m_isInitialized=false;
	mesh="LBArmillarySphere.mesh";
	orbits=false;
	rotates=true;
	targetDirection=Vector3(0,0,0);
}

LBOrbiter::~LBOrbiter(void) {
	for(Subcore * sc:m_subcores){
		delete sc;
	}
	m_subcores.clear();
}
void LBOrbiter::init(SceneManager * sceneMgr, Robot * parent,
		Real tanSpeed,  Vector3 initialAngle, int id ){
	if(m_isInitialized)return;

	Orbiter::init( sceneMgr, parent,  1,tanSpeed, initialAngle, Vector3(0,1,0), Vector3 (0,0,0), Vector3 (0,0,0), Vector3 (0,0,0),parent->m_grid->m_world, id );
	m_entity->setMaterialName("GunMetal");
	m_sceneNode->scale(1.1,1.1,1.1);

	Subcore* subcore=new Subcore();
	subcore->init(m_sceneMgr,parent, m_sceneNode, Vector3(0,-1.2,0),Vector3(.3,.3,.3),0);
	m_subcores.push_back(subcore);
	subcore=new Subcore();
	subcore->init(m_sceneMgr,parent, m_sceneNode,Vector3(0,1.2,0), Vector3(.3,.3,.3),1);
	m_subcores.push_back(subcore);
}
void LBOrbiter::die(){
	if(alive){
		printInfo();
		std::cout<<"is about To die"<<std::endl;

		SceneNode * newSceneNode=m_sceneMgr->getRootSceneNode()->createChildSceneNode(name+"_PhysicsNode");

		newSceneNode->scale(m_sceneNode->_getDerivedScale());
		newSceneNode->setPosition(m_sceneNode->_getDerivedPosition());
		newSceneNode->setOrientation(m_sceneNode->_getDerivedOrientation());
		Entity * newEnt= m_sceneMgr->createEntity(name+"Physics", mesh);
		newEnt->setMaterialName(materialName);
		newSceneNode->attachObject(newEnt);
		for(Subcore * sc:m_subcores){
			sc->changeParentNode(newSceneNode);
		}

		m_sceneNode->detachAllObjects();
		m_sceneMgr->destroyEntity(m_entity->getName());
		m_sceneMgr->destroySceneNode(m_sceneNode->getName());
		m_entity=newEnt;
		m_sceneNode=newSceneNode;

		m_rigidBody = new OgreBulletDynamics::RigidBody(name + "_BODY", m_world);
		std::cout<<m_collisionShape<<std::endl;
		m_rigidBody->setShape(m_sceneNode, m_collisionShape,.5, .5, 1,m_sceneNode->_getDerivedPosition(),m_sceneNode->_getDerivedOrientation());

		if(rotates){
			m_rigidBody->getBulletRigidBody()->setAngularVelocity(OgreBulletCollisions::OgreBtConverter::to(
					m_rotationSpeed*rotationDirection));
		}

		m_rigidBody->setDamping(0.5, 0.5); //linear and rotational
		alive=false;
		printInfo();
		std::cout<<"Is now Dead"<<std::endl;

	}
}

OgreBulletCollisions::CollisionShape * LBOrbiter::storedOrbiterCollisionShape=0;
bool LBOrbiter::shapeMade=false;
void  LBOrbiter::setOrbiterCollisionShape(OgreBulletCollisions::CollisionShape * orbiterCollisionShape)
{
	LBOrbiter::storedOrbiterCollisionShape=orbiterCollisionShape;
	LBOrbiter::shapeMade=true;
}
OgreBulletCollisions::CollisionShape * LBOrbiter::getCollisionShape(){
	if(!LBOrbiter::shapeMade){
		Ogre::Matrix4 transform = Ogre::Matrix4::IDENTITY;
		transform.setScale(Vector3(m_sceneNode->_getDerivedScale()*.75));
		OgreBulletCollisions::StaticMeshToShapeConverter makeShape(m_entity, transform);
		setOrbiterCollisionShape( makeShape.createConvexDecomposition());
	}
	return LBOrbiter::storedOrbiterCollisionShape;
}
