/*
 * LBOrbiter.h
 *
 *  Created on: Apr 15, 2015
 *      Author: robijo04
 */

#ifndef LBORBITER_H_
#define LBORBITER_H_
#include <OgreSceneManager.h>
#include <OgreEntity.h>
#include <OgreFrameListener.h>
#include <OgreString.h>

#include <OgreBulletDynamicsRigidBody.h>
#include <deque>
#include <Shapes/OgreBulletCollisionsSphereShape.h>
#include "Orbiter.h"

class Robot;
class Grid;
class Subcore;

using namespace Ogre;
class LBOrbiter: public Orbiter{
public:
	LBOrbiter();
	virtual ~LBOrbiter();
	virtual void init(SceneManager * sceneMgr, Robot * parent, Real tanSpeed,  Vector3 initialAngle, int id );
	Vector3 targetDirection;
	std::vector<Subcore *> m_subcores;
	virtual void die();
protected:
	static OgreBulletCollisions::CollisionShape * storedOrbiterCollisionShape;
	static void setOrbiterCollisionShape(OgreBulletCollisions::CollisionShape * orbiterCollisionShape);
	static bool shapeMade;
	virtual OgreBulletCollisions::CollisionShape * getCollisionShape();
};

#endif /* LBORBITER_H_ */
