/*
 * Lightning.cpp
 *
 *  Created on: Apr 21, 2015
 *      Author: robijo04
 */
#include "Lightning.h"
Lightning::Lightning(){
	jitter=15;
	jitterStart=1;
}
Lightning::~Lightning(){

	mSceneNode->detachAllObjects();
	mSceneMgr->destroyBillboardChain(mBillboardChain->getName());
	mSceneMgr->destroySceneNode(mSceneNode->getName());


}

void Lightning::init(SceneManager* sceneMgr, GameNode *start_node,GameNode *end_node, Robot* originator , int id)
{
	source=originator;


	String number = StringConverter::toString(id);
	mName=source->name+"Bolt"+number;
	std::cout<<"Initializing Bolt "+mName<<std::endl;

	color=originator->robotColor;
	mStartGameNode=start_node;
	mStartNode=start_node->m_sceneNode;
	mStartPosition=mStartNode->getPosition();

	mEndGameNode=end_node;
	if(mEndGameNode->occupants.size()==0)
	mEndGameNode->m_entity->setMaterialName("Wire"+source->materialName);
	mEndNode=end_node->m_sceneNode;

	mEndPosition=mEndNode->getPosition();


	const Ogre::Vector3 distance = mEndPosition - mStartPosition;

	mBillboardChain = new Ogre::BillboardChain(mName);
	//mBillboardChain->setMaterialName("lightning"); //TODO make lightning material
	mSceneMgr=sceneMgr;
	mSceneNode = mSceneMgr->getRootSceneNode()->createChildSceneNode(mName+"Node");
	mSceneNode->attachObject(mBillboardChain);

	//mBillboardChain->setUseTextureCoords(true);
	mBillboardChain->setUseVertexColours(true);

	Ogre::Vector3 element_position = mStartPosition;
	Ogre::Real element_width = 2;
	Ogre::Real texcoord = 0;
	Ogre::Vector3 step = distance/19;

	for (int i = 0; i<20; ++i)
	{
		texcoord = i;
		mBillboardChain->addChainElement(0, Ogre::BillboardChain::Element(element_position,element_width,texcoord, color, Quaternion(0,0,0,0)));
		element_position += step;
	}

}
void Lightning::update()
{
	mStartPosition = mStartNode->getPosition();
	mEndPosition = mEndNode->getPosition();

	const Ogre::Vector3 distance = mEndPosition - mStartPosition;

	// update position and jitter
	Ogre::Vector3 element_position = mStartPosition;
	Ogre::Vector3 step = distance/19;
	for (int i = 0; i<20; ++i)
	{
		Ogre::BillboardChain::Element element = mBillboardChain->getChainElement(0,i);

		Ogre::Vector3 random_vector(0,0,0);
		if ((i>=jitterStart)&&(i<19))
		{
			random_vector = Ogre::Vector3(rand()%jitter-jitter/2,rand()%jitter-jitter/2,rand()%jitter-jitter/2);
		}
		element.position = step.normalisedCopy().crossProduct(random_vector) + element_position;
		mBillboardChain->updateChainElement(0,i,element);
		element_position += step;
	}
	for(Robot * bot:mEndGameNode->occupants){
		if(bot->alive) bot->die();
	}
	mEndGameNode->isSafe=false;

}
