/*
 * Orbiter.cpp
 *
 *  Created on: Feb 23, 2015
 *      Author: robijo04
 */
#include "Orbiter.h"
#include "Constants.h"
Orbiter::Orbiter() {
	materialName="GunMetal";
	m_isInitialized=false;
	mesh="PBOrbiter.mesh";
	orbits=false;
	rotates=true;
	m_collisionShape=0;
	m_rigidBody=0;
	alive=true;
}

Orbiter::~Orbiter(void) {
	if(m_rigidBody){
		std::cout<<m_rigidBody->getCenterOfMassPosition()<<std::endl;
		delete m_rigidBody;
		//m_rigidBody=0;
		std::cout<<"Rigid Body Destroyed"<<std::endl;
	}
	std::cout<<"Deleting Orbiter"<<std::endl;
	m_sceneNode->detachAllObjects();
	std::cout<<"Objects Detached"<<std::endl;
	m_sceneNode->removeAndDestroyAllChildren();
	std::cout<<"Children Destroyed"<<std::endl;
	m_sceneMgr->destroyEntity(m_entity->getName());
	std::cout<<"Entity Destroyed"<<std::endl;
	m_sceneMgr->destroySceneNode(m_sceneNode->getName());
	std::cout<<"Scene Node Destroyed"<<std::endl;


}
void Orbiter::init(SceneManager * sceneMgr, Robot * parent, Real radius,
		Real tanSpeed, Vector3 initialAngle, Vector3 rotationDirection, Vector3 orbitalAngles, Vector3 initialPosition, Vector3 orbitDirection,OgreBulletDynamics::DynamicsWorld* world, int id ){
	if(m_isInitialized)return;
	this->radius=radius;
	this->parent =parent;
	initialSpeed=m_tanSpeed=tanSpeed;
	this->initialAngle=initialAngle;
	this->rotationDirection=rotationDirection;
	this->orbitalAngles=orbitalAngles;
	this->initialPosition=initialPosition;
	String number = StringConverter::toString(id);
	name=parent->name+"Orbiter"+number;
	m_sceneMgr=sceneMgr;
	m_entity = m_sceneMgr->createEntity(name, mesh);
	m_entity->setMaterialName(materialName);
	//set up the scene node

	m_sceneNode = parent->getSceneNode()->createChildSceneNode(name + "Node");
	m_sceneNode->attachObject(m_entity);
	//m_sceneNode->scale(SCALE,SCALE,SCALE);
	initialPosition.normalise();
	m_position=initialPosition*radius;
	m_sceneNode->setPosition(m_position);
	m_direction=orbitDirection.normalisedCopy();

	initialRot=Degree(initialAngle.normalise());
	m_sceneNode->rotate(initialAngle,initialRot);


	Real period=2*PI*radius/m_tanSpeed;
	m_rotationSpeed=360/period;
	m_isInitialized=true;
	m_world=world;

	//OgreBulletCollisions::CollisionShape shape=&getCollisionShape();
	m_collisionShape=getCollisionShape();
	if(m_collisionShape)
	m_collisionShape=new OgreBulletCollisions::CollisionShape(*m_collisionShape);


	//	std::cerr<<"parent->m_position()= "<<parent->m_position<<" parent->m_sceneNode->_getDerivedPosition()= "<<parent->m_sceneNode->_getDerivedPosition()<<std::endl;
	//	std::cerr<<" m_position= "<<m_position<<" m_sceneNode->getPosition()= "<<m_sceneNode->getPosition()<<" m_sceneNode->_getDerivedPosition()= "<<m_sceneNode->_getDerivedPosition()<<std::endl;


}
void Orbiter::update(const FrameEvent &evt){
	//don't do anything if the object has not been initialized
	if(!m_isInitialized||!alive){
		return;
	}
	if(rotates){
		rotate(evt);
	}
	if(orbits&&evt.timeSinceLastFrame<.1){
		//std::cerr<<"Orbiting"<<std::endl;
		orbit(evt);
	}

}

void Orbiter::orbit(const FrameEvent &evt){

	Real t=evt.timeSinceLastFrame;

	Vector3 v=m_direction*m_tanSpeed;
	Vector3 toParent=(-m_position);

	toParent.normalise();
	Vector3 a=m_tanSpeed*m_tanSpeed/radius*(toParent);
	//std::cerr<<"Velocity: "<<v<<"Time "<<t<<"Acceleration: "<<a<<std::endl;
	v=v+a*t;
	m_position = m_position + (v * t);
	m_sceneNode->setPosition(m_position);
	//m_tanSpeed=v.normalise();
	v.normalise();
	Vector3 xprod=m_direction.crossProduct(toParent);
	m_direction=v;
	Degree rot(m_rotationSpeed*evt.timeSinceLastFrame);

	m_sceneNode->rotate(xprod,rot,Ogre::Node::TS_PARENT);

}
void Orbiter::rotate(const FrameEvent &evt){

	Degree rot(m_rotationSpeed*evt.timeSinceLastFrame);
	m_sceneNode->rotate(rotationDirection,rot);
}
void Orbiter::accelerate(Real acceleration){
	m_tanSpeed+=acceleration;
	Real period=2*PI*radius/m_tanSpeed;
	m_rotationSpeed=360/period;
}
void Orbiter::resetSpeed(){
	m_tanSpeed=initialSpeed;
	Real period=2*PI*radius/m_tanSpeed;
	m_rotationSpeed=360/period;
}
void Orbiter::die(){
	if(alive){
		printInfo();
		std::cout<<"is about To die"<<std::endl;

		SceneNode * newSceneNode=m_sceneMgr->getRootSceneNode()->createChildSceneNode(name+"_PhysicsNode");

		newSceneNode->scale(m_sceneNode->_getDerivedScale());
		newSceneNode->setPosition(m_sceneNode->_getDerivedPosition());
		newSceneNode->setOrientation(m_sceneNode->_getDerivedOrientation());
		Entity * newEnt= m_sceneMgr->createEntity(name+"Physics", mesh);
		newEnt->setMaterialName(materialName);
		newSceneNode->attachObject(newEnt);

		m_sceneNode->detachAllObjects();
		m_sceneMgr->destroyEntity(m_entity->getName());
		m_sceneMgr->destroySceneNode(m_sceneNode->getName());
		m_entity=newEnt;
		m_sceneNode=newSceneNode;

		m_rigidBody = new OgreBulletDynamics::RigidBody(name + "_BODY", m_world);
		std::cout<<m_collisionShape<<std::endl;
		m_rigidBody->setShape(m_sceneNode, m_collisionShape,.5, .5, 1,m_sceneNode->_getDerivedPosition(),m_sceneNode->_getDerivedOrientation());
		if(orbits){
			m_rigidBody->setLinearVelocity(m_tanSpeed*m_direction);
		}
		if(rotates){
			m_rigidBody->getBulletRigidBody()->setAngularVelocity(OgreBulletCollisions::OgreBtConverter::to(
					m_rotationSpeed*rotationDirection));
		}

		m_rigidBody->setDamping(0.5, 0.5); //linear and rotational
		alive=false;
		printInfo();
		std::cout<<"Is now Dead"<<std::endl;

	}
}
void Orbiter::printInfo(){
	std::cout<<"Orbiter Name: "<<name<<std::endl;
	std::cout<<"parent->m_position()= "<<parent->m_position<<" parent->m_sceneNode->_getDerivedPosition()= "<<parent->m_sceneNode->_getDerivedPosition()<<std::endl;
	std::cout<<" m_position= "<<m_position<<" m_sceneNode->getPosition()= "<<m_sceneNode->getPosition()<<" m_sceneNode->_getDerivedPosition()= "<<m_sceneNode->_getDerivedPosition()<<std::endl;
	std::cout<<" rotationDirection= "<<rotationDirection<<" m_rotationSpeed= "<<m_rotationSpeed<<" m_tanSpeed= "<<m_tanSpeed<< "initialSpeed= "<< initialSpeed<<std::endl;

}
OgreBulletCollisions::CollisionShape * Orbiter::getCollisionShape(){
	Ogre::Matrix4 transform = Ogre::Matrix4::IDENTITY;
	transform.setScale(Vector3(m_sceneNode->_getDerivedScale()*.75));
	OgreBulletCollisions::StaticMeshToShapeConverter makeShape(m_entity, transform);
	return makeShape.createConvexDecomposition();
}


