/*
 * Orbiter.h
 *
 *  Created on: Apr 15, 2015
 *      Author: robijo04
 */

#ifndef ORBITER_H_
#define ORBITER_H_
#include <OgreSceneManager.h>
#include <OgreEntity.h>
#include <OgreFrameListener.h>
#include <OgreString.h>

#include <OgreBulletDynamicsRigidBody.h>
#include <deque>
#include <Shapes/OgreBulletCollisionsSphereShape.h>


class Robot;
class Grid;


using namespace Ogre;
class Orbiter{
public:
	Orbiter();
	virtual ~Orbiter();
	Entity * m_entity;
	SceneNode * m_sceneNode;
	SceneManager* m_sceneMgr;
	Robot * parent;
	String name;
	String mesh;
	String materialName;//set for each subclass
	Real m_tanSpeed;
	Real m_rotationSpeed;
	Vector3 rotationDirection; //1/0/-1 for each saying rotate around that axis.
	Vector3 orbitalAngles; // 1/0/-1 for each saying orbit around that axis.
	Vector3 initialPosition;//normalized relative position. Only really needed for Fastbot now.
	Real radius;
	Vector3 initialAngle; //might need to be a vector3 as well
	Degree initialRot;
	Vector3 m_position;
	Vector3 m_direction;
	Real initialSpeed;
	bool m_isInitialized;
	bool orbits;
	bool rotates;
	bool alive;
	virtual void orbit(const FrameEvent& evt);
	virtual void rotate(const FrameEvent& evt);
	virtual void update(const FrameEvent& evt);
	virtual void init(SceneManager * sceneMgr, Robot * parent, Real radius, Real tanSpeed, Vector3 initialAngle, Vector3 rotationDirection, Vector3 orbitalAngles, Vector3 initialPosition, Vector3 orbitDirection, OgreBulletDynamics::DynamicsWorld* world, int id );
	virtual void accelerate(Real accleration);
	virtual void resetSpeed();
	virtual void printInfo();
	OgreBulletCollisions::CollisionShape *m_collisionShape;
	OgreBulletDynamics::RigidBody* m_rigidBody;
	OgreBulletDynamics::DynamicsWorld* m_world;
	virtual void die();
protected:
	virtual OgreBulletCollisions::CollisionShape * getCollisionShape();



};

#endif /* ORBITER_H_ */
