/*
 * PBOrbiter.cpp
 *
 *  Created on: Feb 23, 2015
 *      Author: robijo04
 */
#include "PBOrbiter.h"
#include "Constants.h"
PBOrbiter::PBOrbiter() {
	m_isInitialized=false;
	mesh="PBOrbiter.mesh";
	orbits=false;
	rotates=true;
	materialName="WhiteMetal";
}

PBOrbiter::~PBOrbiter(void) {
}
void PBOrbiter::init(SceneManager * sceneMgr, Robot * parent, Real radius,
		Real tanSpeed, Vector3 initialAngle, Vector3 rotationDirection, int id ){
	if(m_isInitialized)return;

	Orbiter::init( sceneMgr, parent,  radius,tanSpeed, initialAngle, rotationDirection, Vector3 (0,0,0), Vector3 (0,0,0), Vector3 (0,0,0), parent->m_grid->m_world,id );
	m_entity->setMaterialName(materialName);
	m_sceneNode->scale(radius,radius,radius);

}

OgreBulletCollisions::CollisionShape * PBOrbiter::storedOrbiterCollisionShape=0;
bool PBOrbiter::shapeMade=false;
void  PBOrbiter::setOrbiterCollisionShape(OgreBulletCollisions::CollisionShape * orbiterCollisionShape)
{
	PBOrbiter::storedOrbiterCollisionShape=orbiterCollisionShape;
	PBOrbiter::shapeMade=true;
}
OgreBulletCollisions::CollisionShape * PBOrbiter::getCollisionShape(){
	if(!PBOrbiter::shapeMade){
		Ogre::Matrix4 transform = Ogre::Matrix4::IDENTITY;
		transform.setScale(Vector3(m_sceneNode->_getDerivedScale()*.75));
		OgreBulletCollisions::StaticMeshToShapeConverter makeShape(m_entity, transform);
		setOrbiterCollisionShape( makeShape.createConvexDecomposition());
	}
	return PBOrbiter::storedOrbiterCollisionShape;
}

