/*
 * PlayerBot.cpp
 *
 *  Created on: Apr 15, 2015
 *      Author: robijo04
 */
#include "PlayerBot.h"
#include "Constants.h"
#include "PBOrbiter.h"

PlayerBot::PlayerBot(){
	alive=true;
	converted=false;
	timeMoving=0;
	numJumps=1;
	m_isInitialized=false;
	robotColor=ColourValue(0.0f,1.0f,1.0f,0.5f);
	materialName="CyanCore";
}
PlayerBot::~PlayerBot(){

}

void PlayerBot::init(Ogre::SceneManager *sceneMgr,Grid * grid, GameNode * currentNode, int id){

	if(m_isInitialized){
		return;
	}

	Robot::init(sceneMgr, grid, currentNode, id);
	currentNode->isSafe=true;
	m_core->setMaterialName(materialName);
	grid->playerNode=m_node;
	Real radius=1.1;
	Vector3 dir(0,1,0);

	for(int i=0;i<8;i++){
		PBOrbiter * orbit= new PBOrbiter();
		//orbit->init(sceneMgr, m_node, i, radius+i*2, Ogre::Degree(45*i), dir);
		orbit->init(sceneMgr, this, radius+i*.2, 7, Vector3(0,45*i,0),dir,i );
		m_orbiters.push_back(orbit);
		if(dir.y==1)dir.y=-1;
		else dir.y=1;

	}

}
