/*
 * Robot.cpp
 *
 *  Created on: Apr 15, 2015
 *      Author: robijo04
 */
#include "Robot.h"
#include "Constants.h"

Robot::Robot(){
	alive=true;
	converted=false;
	String materialName="WhiteCore.material";
	timeMoving=0;
	numJumps=1;
	jumpsRemaining=numJumps;
	moveBeam=0;
}
Robot::~Robot(){
	std::cout<<"Deleting bot core= "<<materialName<<std::endl;
	for(Orbiter* orb:m_orbiters){
		delete orb;
	}
	std::cout<<"Deleted orbiters"<<std::endl;
	m_orbiters.clear();
	std::cout<<"m_orbiters cleared"<<std::endl;
	clearBolts();
	std::cout<<"Cleared bolts"<<std::endl;
	if(moveBeam){
		delete moveBeam;
		moveBeam=0;
	}
	std::cout<<"Deleted Move Beam"<<std::endl;

	m_sceneNode->detachAllObjects();
	m_sceneMgr->destroyEntity(m_core->getName());
	m_sceneMgr->destroySceneNode(m_sceneNode->getName());
	std::cout<<"node and core deleted"<<std::endl;

}


void Robot::move(GameNode * node){
	std::cout<<"Moving!"<<std::endl;
	Vector3 dest=node->getPosition();
	destination=dest;
	Real distance=m_position.distance(dest);
	moveTime=STEP_TIME/numJumps;
	m_speed=distance/moveTime*.7;
	m_direction=dest-m_position;
	m_direction.normalise();
	changeState(REV_UP);
	m_node->removeRobot(this);
	m_node=node;

	moveBeam=new Beam();
	moveBeam->init(m_sceneMgr,this,node,robotColor);
	jumpsRemaining--;
	clearBolts();
}
void Robot::changeState(int newState){
	state=newState;
	timeInState=0;
}
void Robot::warp(GameNode * target){
	changeState(W_REV_UP);
	destination=target->getPosition();
	m_node->removeRobot(this);
	m_node=target;

	jumpsRemaining--;
	moveTime=(STEP_TIME+ANIMATION_TIME)/2;
	clearBolts();
}
void Robot::destabilize(){

}
Vector3 m_position;
void Robot::die(){
	if(alive){
		alive=false;
		clearBolts();
		for(Orbiter * orb:m_orbiters){
			orb->die();
		}
		ParticleEmitter * em=plasmaCore->getEmitter(0);
		em->setEmissionRate(5);
		em->setTimeToLive(.3,.4);
		m_node->m_entity->setMaterialName("BlackCore");
		changeState(STATIONARY);
	}
}

void Robot::init(Ogre::SceneManager *sceneMgr,Grid * grid, GameNode * currentNode, int id){

	if(m_isInitialized){
		return;
	}
	this->id=id;
	m_node=currentNode;
	m_sceneMgr=sceneMgr;
	Ogre::String number = Ogre::StringConverter::toString(id);
	name="RobotCore"+number;

	m_core = m_sceneMgr->createEntity(name, "Core.mesh");
	m_core->setMaterialName(materialName);
	//set up the scene node
	m_sceneNode = m_sceneMgr->getRootSceneNode()->createChildSceneNode(name + "Node");
	m_sceneNode->attachObject(m_core);
	m_sceneNode->scale(SCALE,SCALE,SCALE);
	m_position=currentNode->getPosition();
	m_sceneNode->setPosition(m_position);
	m_grid=grid;
	//set for each subclass
	m_coreLight=sceneMgr->createLight("CoreLight"+number);
	m_coreLight->setType(Light::LT_POINT);
	m_coreLight->setDiffuseColour(robotColor.r,robotColor.g,robotColor.b);
	m_coreLight->setSpecularColour(robotColor.r,robotColor.g,robotColor.b);
	//m_coreLight->setAttenuation()
	m_sceneNode->attachObject(m_coreLight);
	//	OgreBulletCollisions::CollisionShape *coreCollisionShape;
	//	OgreBulletDynamics::RigidBody* coreRigidBody;
	m_node->addRobot(this);
	m_isInitialized=true;

	plasmaCore=m_sceneMgr->createParticleSystem(name+"plasmaCore","JDR/Core");
	plasmaCore->getEmitter(0)->setColour(robotColor);
	m_sceneNode->attachObject(plasmaCore);
	clearBolts();


}
Vector3 Robot::getPosition(){
	return m_position;
}
SceneNode * Robot::getSceneNode(){
	return m_sceneNode;
}
bool Robot::isEqual(Robot* bot){
	return bot->id==id;
}
void Robot::clearBolts(){
	//std::cerr<<"about to clear";
	for(Lightning * bolt:bolts){
		if(bolt->mEndGameNode->occupants.size()==0){
			bolt->mEndGameNode->m_entity->setMaterialName("WireWhiteCore");
		}
		delete bolt;
	}
	bolts.clear();
	//std::cerr<<"cleared";
}
void Robot::printInfo(){
	std::cout<<"Robot name "<<name<<" Robot type "<<materialName<<std::endl;
	std::cout<<"number of Orbiters "<<m_orbiters.size()<<std::endl;
	for(Orbiter * orb:m_orbiters){
		orb->printInfo();
	}
}
void Robot::update(const Ogre::FrameEvent& evt){
	if(!m_isInitialized) return;
	timeInState+=evt.timeSinceLastEvent;
	//std::cout<<"Time in State="<<timeInState<<std::endl;
	if(alive){
		if(state==REV_UP){
			revUp(evt);
		}
		else if(state==MOVING){
			moving(evt);
		}else if(state==REV_DOWN){
			revDown(evt);
		}else if(state==W_REV_UP){
			warpRevUp(evt);
		}else if(state==W_REV_DOWN){
			warpRevDown(evt);
		}

		for(Orbiter* orb:m_orbiters){
			orb->update(evt);
		}
		for(Lightning* bolt:bolts){
			bolt->update();
		}
	}

}
void Robot::revUp(const Ogre::FrameEvent& evt){
	for(Orbiter* orb:m_orbiters){
		orb->accelerate(.2/ANIMATION_TIME);
	}
	if(timeInState>=ANIMATION_TIME){
		changeState(MOVING);
	}
}
void Robot::moving(const Ogre::FrameEvent& evt){
	if(timeInState>=moveTime){

		m_position=destination;

		m_sceneNode->setPosition(destination);
		std::cout<<"Finished Moving Here"<<std::endl;
		//std::cout<<moveBeam->mName<<std::endl;
		delete moveBeam;
		moveBeam=0;
		std::cout<<jumpsRemaining<<std::endl;
		m_node->addRobot(this);
		if(m_node->occupants.size()>1){
			die();
			changeState(STATIONARY);
			m_node->occupants[0]->die();
		}else if(jumpsRemaining==0){
			changeState(REV_DOWN);
			destabilize();
			jumpsRemaining=numJumps;
		}else if(alive){
			move(m_grid->dirToPlayer(m_node));
			changeState(MOVING);
		}

	}else{
		m_position=m_position+m_direction*m_speed*evt.timeSinceLastFrame;
		m_sceneNode->setPosition(m_position);

		moveBeam->update();
	}
}
void Robot::revDown(const Ogre::FrameEvent& evt){
	if(m_node->occupants.size()>1){
		die();
		changeState(STATIONARY);
	}
	else if(timeInState>=ANIMATION_TIME){
		changeState(STATIONARY);
		for(Orbiter* orb:m_orbiters){
			orb->resetSpeed();
		}
	}else{
		for(Orbiter* orb:m_orbiters){
			orb->accelerate(-.2/ANIMATION_TIME);
		}
	}
}
void Robot::warpRevUp(const Ogre::FrameEvent& evt){
	for(Orbiter* orb:m_orbiters){
		orb->accelerate(.2/ANIMATION_TIME);
	}
	ParticleEmitter * em=plasmaCore->getEmitter(0);
	Real rate=em->getEmissionRate();
	em->setEmissionRate(rate+100*evt.timeSinceLastFrame);
	Real max=em->getMaxTimeToLive();
	Real min=em->getMinTimeToLive();
	em->setTimeToLive(max+.005,min+.005);
	if(timeInState>=moveTime){
		m_position=destination;
		m_sceneNode->setPosition(destination);

		m_node->addRobot(this);
		if(m_node->occupants.size()>1){
			die();
			changeState(STATIONARY);
		}else {
			destabilize();
			changeState(W_REV_DOWN);
		}
	}
}
void Robot::warpRevDown(const Ogre::FrameEvent& evt){
	if(timeInState>=moveTime){
		changeState(STATIONARY);
		for(Orbiter* orb:m_orbiters){
			orb->resetSpeed();

		}ParticleEmitter * em=plasmaCore->getEmitter(0);
		em->setEmissionRate(50);
		em->setTimeToLive(.3,.4);
		std::cout<<"Warp done!"<<std::endl;
		if(jumpsRemaining==0) jumpsRemaining=numJumps;
	}else{
		for(Orbiter* orb:m_orbiters){
			orb->accelerate(-.2/ANIMATION_TIME);
		}
		ParticleEmitter * em=plasmaCore->getEmitter(0);
		Real rate=em->getEmissionRate();
		em->setEmissionRate(rate-100*evt.timeSinceLastFrame);
		Real max=em->getMaxTimeToLive();
		Real min=em->getMinTimeToLive();
		em->setTimeToLive(max-.005,min-.005);
	}
}
