/*
 * Robot.h
 *
 *  Created on: Apr 15, 2015
 *      Author: robijo04
 */

#ifndef ROBOT_H_
#define ROBOT_H_

#include <OgreSceneManager.h>
#include <OgreEntity.h>
#include <OgreFrameListener.h>
#include <OgreString.h>

#include <OgreBulletDynamicsRigidBody.h>
#include <deque>
#include <Shapes/OgreBulletCollisionsSphereShape.h>

class GameNode;
class Grid;
class Orbiter;
class Beam;
class Lightning;
using namespace Ogre;

class Robot{
public:
	Robot();
	virtual ~Robot();
	GameNode * m_node;
	SceneNode * m_sceneNode;
	SceneManager* m_sceneMgr;
	Entity * m_core;
	Grid * m_grid;
	String name;
	String materialName; //set for each subclass
	std::vector<Orbiter*>  m_orbiters;
	Light * m_coreLight;
	bool alive;
	bool converted;
	virtual void update(const Ogre::FrameEvent& evt);
	virtual void move(GameNode * node);
	int numJumps;
	int jumpsRemaining;
	Real moveTime;

	Vector3 m_position;
	virtual void die();
	virtual void init(Ogre::SceneManager *sceneMgr,Grid * grid, GameNode * currentNode, int id);
	bool m_isInitialized;

	int id;
	Vector3 destination;
	Vector3 m_direction;
	Real timeMoving;
	Real m_speed;
	virtual Vector3 getPosition();
	virtual SceneNode * getSceneNode();
	Beam * moveBeam;
	ColourValue robotColor;
	bool isEqual(Robot * bot);
	ParticleSystem * plasmaCore;
	int state=0;
	Real timeInState;
	virtual void changeState(int newState);
	virtual void warp(GameNode* target);

	std::vector<Lightning*> bolts;
	virtual void clearBolts();
	virtual void printInfo();
protected:
	virtual void destabilize();
	virtual void revUp(const Ogre::FrameEvent& evt);
	virtual void moving(const Ogre::FrameEvent& evt);
	virtual void revDown(const Ogre::FrameEvent& evt);
	virtual void warpRevUp(const Ogre::FrameEvent& evt);
	virtual void warpRevDown(const Ogre::FrameEvent& evt);

};


#endif /* ROBOT_H_ */
