/*
 * RobotsApp.cpp
 *
 *  Created on: Feb 3, 2011
 *      Author: cpresser
 */

#include "RobotsApp.h"
#include <Shapes/OgreBulletCollisionsStaticPlaneShape.h>
#include <Shapes/OgreBulletCollisionsBoxShape.h>
#include <Shapes/OgreBulletCollisionsSphereShape.h>



RobotsApp::RobotsApp():
m_numEntities(0),
m_moveSpeed(50),
m_gravity(0, -98.1, 0),
m_bounds(),
currentID(0)
{
	srand(std::time(0));
	gameState=PLAYER_SELECTING;
	timeInState=0;
	mRaySceneQuery=0;
}

RobotsApp::~RobotsApp() {
	//empty the queues, free memory
	//	std::deque<OgreBulletDynamics::RigidBody *>::iterator itBody = m_bodies.begin();
	//	while(m_bodies.end() != itBody){
	//		delete *itBody;
	//		++itBody;
	//	}
	//
	//	std::deque<OgreBulletCollisions::CollisionShape *>::iterator itShape = m_shapes.begin();
	//	while(m_shapes.end() != itShape){
	//		delete *itShape;
	//		++itShape;
	//	}
	//
	//	m_bodies.clear();
	//	m_shapes.clear();
	//
	//	if(m_world)
	//		delete m_world;
	//
	//	if(m_debugDrawer)
	//		delete m_debugDrawer;
	if(mRaySceneQuery){
		mSceneMgr->destroyQuery(mRaySceneQuery);
	}
}

void RobotsApp::createScene(void)
{
	//perform the magic required to make textures work
	//Ogre::TextureManager::getSingleton().setDefaultNumMipmaps(0);

	//create the scene stuff

	// Set ambient light
	mSceneMgr->setAmbientLight(Ogre::ColourValue(0.7, 0.7, 0.7));

	// Create a light
	Ogre::Light* l = mSceneMgr->createLight("MainLight");
	l->setPosition(20,80,50);


	//move camera
	mCamera->move(Ogre::Vector3::UNIT_Y * 10);


	//build a floor
	//	Ogre::Plane plane(Ogre::Vector3::UNIT_Y, 0);
	//
	//	Ogre::MeshManager::getSingleton().createPlane("ground",
	//			Ogre::ResourceGroupManager::DEFAULT_RESOURCE_GROUP_NAME,
	//			plane, 200000, 200000, 20, 20, true, 1, 9000, 9000,
	//			Ogre::Vector3::UNIT_Z);
	//
	//	Ogre::Entity* entGround = mSceneMgr->createEntity("GroundEntity", "ground");
	//	mSceneMgr->getRootSceneNode()->createChildSceneNode()->attachObject(entGround);
	//
	//	entGround->setMaterialName("Examples/Rockwall");
	//	entGround->setCastShadows(false);


	//bullet physics
	m_world = new OgreBulletDynamics::DynamicsWorld(mSceneMgr, m_bounds, m_gravity);
	m_debugDrawer= new OgreBulletCollisions::DebugDrawer();
	m_debugDrawer->setDrawWireframe(true);
	m_world->setDebugDrawer(m_debugDrawer);
	m_world->setShowDebugShapes(true);
	//
	//	//Set up the ground
	//	OgreBulletCollisions::CollisionShape *shape = new OgreBulletCollisions::StaticPlaneCollisionShape(Ogre::Vector3::UNIT_Y, 0);
	//	OgreBulletDynamics::RigidBody *groundBody= new OgreBulletDynamics::RigidBody("GroundBody",m_world);
	//	groundBody->setStaticShape(shape, 0.1, 0.8);
	//
	//
	//	m_bodies.push_back(groundBody);
	//	m_shapes.push_back(shape);
	grid=new Grid();
	grid->init(mSceneMgr,m_world,6);
	//		player=new PlayerBot();
	//		std::cerr<<"Got here"<<std::endl;
	//		player->init(mSceneMgr,grid, grid->nodes[1], getID());
	//		robots.push_back(player);
	//		grid->getNeighbors(player->m_node->id);
	//	SBtest=new StandardBot();
	//	SBtest->init(mSceneMgr,grid, grid->nodes[2], getID());
	//	robots.push_back(SBtest);
	//	WBtest=new WarpBot();
	//	WBtest->init(mSceneMgr,grid, grid->nodes[3], getID());
	//	robots.push_back(WBtest);
	//	test=new FastBot();
	//	test->init(mSceneMgr,grid, grid->nodes[4], getID());
	//	robots.push_back(test);
	//	test=new BarrierBot();
	//	test->init(mSceneMgr,grid, grid->nodes[5], getID());
	//	robots.push_back(test);
	//	test=new LaserBot();
	//	test->init(mSceneMgr,grid, grid->nodes[6], getID());
	//	robots.push_back(test);
	//	test=new DemonLaserBot();
	//	test->init(mSceneMgr,grid, grid->nodes[0], getID());
	//	robots.push_back(test);


	for(int i=0;i<6;i++){
		Robot * bot;
		if(i==0){
			bot=new StandardBot();
		}else if(i==1){
			bot=new WarpBot();
		}else if(i==2){
			bot=new FastBot();
		}else if(i==3){
			bot=new LaserBot();
		}else if(i==4){
			bot=new BarrierBot();
		}else if(i==5){
			bot=new DemonLaserBot();
		}
		bot->init(mSceneMgr,grid, grid->nodes[0], getID());
		delete bot;
	}
	changeLevel(1);
	//player->move(grid->nodes[30]);
	std::cerr<<"Got here"<<std::endl;
	//testBeam=new Beam();
	//testBeam->init(mSceneMgr, robots[0], grid->nodes[2], robots[0]->robotColor);
	//	bolt=new Lightning();
	//	bolt->init(mSceneMgr, grid->nodes[0], grid->nodes[1], ColourValue(0.0f,1.0f,0.0f,0.5f), getID());
	selected=mSceneMgr->createParticleSystem("selected","JDR/Core");
	selNode=mSceneMgr->getRootSceneNode()->createChildSceneNode("SelectedNode");
	selNode->scale(SCALE,SCALE,SCALE);
	selNode->attachObject(selected);
	selected->setVisible(false);

	//
	//	grid->nodes[0]->m_sceneNode->attachObject(selected);
	//	stepBots();
}


bool RobotsApp::mousePressed( const OIS::MouseEvent& evt, OIS::MouseButtonID id ){
	if(id==OIS::MB_Left){
		if(gameState==PLAYER_SELECTING&&selected->getVisible()){
			movePlayer(selectedNode);

		}
	}

	return true;
}


bool RobotsApp::keyPressed(const OIS::KeyEvent & arg)
{
	bool result = BaseApplication::keyPressed(arg);

	switch(arg.key){

	case OIS::KC_P:
		printOrbiters();
		break;
	case OIS::KC_1:
		changeLevel(1);
		break;
	case OIS::KC_2:
		changeLevel(2);
		break;
	case OIS::KC_3:
		changeLevel(3);
		break;
	case OIS::KC_4:
		changeLevel(4);
		break;
	case OIS::KC_5:
		changeLevel(5);
		break;
	case OIS::KC_6:
		changeLevel(6);
		break;
	case OIS::KC_7:
		changeLevel(12);
		break;
//	case OIS::KC_8:
//		changeLevel(8);
//		break;
//	case OIS::KC_9:
//		changeLevel(9);
//		break;
//	case OIS::KC_0:
//		changeLevel(10);
//		break;
//	case OIS::KC_L:
//		changeLevel(11);
//		break;
//	case OIS::KC_DELETE:
//		changeLevel(12);
//		break;
	default:
		break;
	}
	if(gameState==PLAYER_SELECTING){
		if(arg.key==OIS::KC_J){
			warpPlayer();

		}
		if(arg.key==OIS::KC_H){
			changeState(BOTS_MOVING);
			stepBots();
			grid->clearMarkers();
			selected->setVisible(false);
		}
	}
	return result;
}

bool RobotsApp::keyReleased(const OIS::KeyEvent & arg)
{
	bool result = BaseApplication::keyReleased(arg);
	return result;
}



bool RobotsApp::frameEnded(const Ogre::FrameEvent & evt)
{
	bool result = BaseApplication::frameEnded(evt);


	return result;
}



bool RobotsApp::frameStarted(const Ogre::FrameEvent & evt)
{
	bool result = BaseApplication::frameStarted(evt);


	return result;
}

void RobotsApp::createFrameListener(void) {
	BaseApplication::createFrameListener();

	mRaySceneQuery= mSceneMgr->createRayQuery(Ogre::Ray());
}

bool RobotsApp::frameRenderingQueued(const Ogre::FrameEvent & evt)
{
	if(evt.timeSinceLastFrame<.1){

		m_world->stepSimulation(evt.timeSinceLastFrame);
		//std::cout<<"Updated sim"<<std::endl;


		timeInState+=evt.timeSinceLastFrame;
		if( gameState==PLAYER_SELECTING){
			if(isGameOver()){
				if(player->alive){
					changeLevel(std::min(currentLevel+1,6));
				}else{
					changeLevel(currentLevel);
				}
			}else{
				mRaySceneQuery->setRay(Ray(mCamera->getPosition(), mCamera->getDirection()));
				mRaySceneQuery->setQueryMask(NODE_FLAG);
				RaySceneQueryResult &qResult =mRaySceneQuery->execute();
				RaySceneQueryResult::iterator it =qResult.begin();
				bool done=false;
				while(it != qResult.end() && it->movable&&!done){
					SceneNode* snode=it->movable->getParentSceneNode();
					Vector3 pos=snode->getPosition();
					Vector3 relpos=snode->getPosition();

					relpos.x=pos.x/NODE_DISTANCE;
					relpos.y=pos.y/NODE_DISTANCE;
					relpos.z=pos.z/NODE_DISTANCE;
					int id=grid->VectorToID(relpos);
					bool isNeighbor=false;
					for(GameNode* gm:playerNeighbors){
						if(gm->id==id){
							isNeighbor=true;
						}
					}
					if(isNeighbor){
						selNode->setPosition(pos);
						selected->setVisible(true);
						selectedNode=grid->nodes[id];
						done=true;
					}else{
						selected->setVisible(false);
						it++;
					}
				}
			}
		}
		else if(gameState==PLAYER_MOVING){
			if(timeInState>=STEP_TIME+ANIMATION_TIME){
				changeState(BOTS_MOVING);
				stepBots();
				grid->clearMarkers();
			}
		}else if(gameState==BOTS_MOVING){
			if(botsDone()){
				changeState(PLAYER_SELECTING);

				grid->setMarkers();
			}
		}
	}
	for (Robot * bot :robots) bot->update(evt);

	bool result = BaseApplication::frameRenderingQueued(evt);

	//m_world->stepSimulation(evt.timeSinceLastFrame);

	//bolt->update();
	//testBeam->update();
	return result;
}
int RobotsApp::getID(){
	int i=currentID;
	currentID++;
	return i;
}

void RobotsApp::movePlayer(GameNode* dest){
	player->move(dest);
	grid->playerNode=player->m_node;
	playerNeighbors=grid->getNeighbors(player->m_node->id);
	changeState(PLAYER_MOVING);
}
void RobotsApp::warpPlayer(){
	std::vector<GameNode *> safeNodes=grid->getSafeNodes();
	player->warp(safeNodes[rand()%safeNodes.size()]);
	selNode->setPosition(player->m_node->m_position);
	selected->setVisible(true);
	grid->playerNode=player->m_node;
	playerNeighbors=grid->getNeighbors(player->m_node->id);
	changeState(PLAYER_MOVING);
}
void RobotsApp::stepBots(){
	for (Robot * bot :robots){
		if(bot->alive){
			if(bot->id!=player->id){
				bot->move(grid->dirToPlayer(bot->m_node));
			}
		}
	}
}
void RobotsApp::setUpNextMove(){

}
void RobotsApp::setUpLevel(int level){
	std::cout<<"Setting up level"<<std::endl;

	int numBots=20;
	currentLevel=level;
	grid->clearMarkers();
	std::cout<<"Cleared grid Markers"<<std::endl;
	GameNode * dest=grid->nodes[rand()%grid->nodes.size()];
	mCamera->setPosition(dest->m_position);
	std::cout<<"found Random location for Player, set Camera"<<std::endl;

	player=new PlayerBot();
	player->init(mSceneMgr,grid, dest, getID());
	robots.push_back(player);
	playerNeighbors=grid->getNeighbors(dest->id);
	std::cout<<"Initialized Player"<<std::endl;


	grid->markAround(player->m_node->id,2);
	std::cout<<"Marked grid around player"<<std::endl;

	std::vector<GameNode *> safeNodes=grid->getSafeNodes();
	std::cout<<"Number of safe nodes: "<<safeNodes.size()<<std::endl;
	int indexes[numBots];
	for(int j=0;j<numBots;j++){
		int randindex=rand()%safeNodes.size();
		for(int l=0;l<j;l++){
			if(indexes[l]==randindex){
				l=0;
				randindex=rand()%safeNodes.size();
			}
		}
		indexes[j]=randindex;
		std::cout<<"Index Selected: "<<randindex<<std::endl;
	}
	std::cout<<"selected Bot Locations"<<std::endl;

	for(int i=0;i<numBots;i++){
		int botType=rand()%level;
		Robot * bot;
		if(botType==0){
			bot=new StandardBot();
		}else if(botType==1){
			bot=new WarpBot();
		}else if(botType==2){
			bot=new FastBot();
		}else if(botType==3){
			bot=new LaserBot();
		}else if(botType==4){
			bot=new BarrierBot();
		}else if(botType==5){
			bot=new DemonLaserBot();
		}
		bot->init(mSceneMgr,grid, safeNodes[indexes[i]], getID());
		robots.push_back(bot);
		std::cout<<"made bot"<<i+1<<std::endl;

	}
	grid->clearMarkers();
	grid->setMarkers();
	std::cout<<"Reset Grid Markers"<<std::endl;
	changeState(PLAYER_SELECTING);

}
void RobotsApp::setUpSingleBotLevel(int level){
	std::cout<<"Setting up level"<<std::endl;

	int numBots=20;

	grid->clearMarkers();
	std::cout<<"Cleared grid Markers"<<std::endl;
	GameNode * dest=grid->nodes[rand()%grid->nodes.size()];
	mCamera->setPosition(dest->m_position);
	std::cout<<"found Random location for Player, set Camera"<<std::endl;

	player=new PlayerBot();
	player->init(mSceneMgr,grid, dest, getID());
	robots.push_back(player);
	playerNeighbors=grid->getNeighbors(dest->id);
	std::cout<<"Initialized Player"<<std::endl;


	grid->markAround(player->m_node->id,2);
	std::cout<<"Marked grid around player"<<std::endl;

	std::vector<GameNode *> safeNodes=grid->getSafeNodes();
	std::cout<<"Number of safe nodes: "<<safeNodes.size()<<std::endl;
	int indexes[numBots];
	for(int j=0;j<numBots;j++){
		int randindex=rand()%safeNodes.size();
		for(int l=0;l<j;l++){
			if(indexes[l]==randindex){
				l=0;
				randindex=rand()%safeNodes.size();
			}
		}
		indexes[j]=randindex;
		std::cout<<"Index Selected: "<<randindex<<std::endl;
	}
	std::cout<<"selected Bot Locations"<<std::endl;

	for(int i=0;i<numBots;i++){
		int botType=level-1;
		Robot * bot;
		if(botType==0){
			bot=new StandardBot();
		}else if(botType==1){
			bot=new WarpBot();
		}else if(botType==2){
			bot=new FastBot();
		}else if(botType==3){
			bot=new BarrierBot();
		}else if(botType==4){
			bot=new LaserBot();
		}else if(botType==5){
			bot=new DemonLaserBot();
		}
		bot->init(mSceneMgr,grid, safeNodes[indexes[i]], getID());
		robots.push_back(bot);
		std::cout<<"made bot"<<i+1<<std::endl;

	}
	grid->clearMarkers();
	grid->setMarkers();
	std::cout<<"Reset Grid Markers"<<std::endl;
	changeState(PLAYER_SELECTING);

}
void RobotsApp::changeState(int newState){
	gameState=newState;
	timeInState=0;
}
void RobotsApp::changeLevel(int level){
	std::cout<<"Resetting"<<std::endl;
	for(Robot * bot:robots){
		delete bot;
	}
	std::cout<<"Bots Deleted"<<std::endl;
	for(GameNode * gm:grid->nodes){
		gm->occupants.clear();
	}
	std::cout<<"Grid occupants Deleted"<<std::endl;
	robots.clear();
	std::cout<<"Robots Empty"<<std::endl;
	if(level<=6){
		setUpLevel(level);
	}else{
		setUpSingleBotLevel(level-6);
	}

}
void RobotsApp::printOrbiters(){
	for(Robot * bot:robots){
		bot->printInfo();
	}
}
bool RobotsApp::isGameOver(){
	if(!player->alive){
		return true;
	}
	for( int i=1; i<robots.size();i++){
		if( robots[i]->alive){
			return false;
		}
	}
	return true;
}
bool RobotsApp::botsDone(){
	for( int i=1; i<robots.size();i++){
		if( robots[i]->state!=STATIONARY){
			return false;
		}
	}
	return true;
}

#if OGRE_PLATFORM == OGRE_PLATFORM_WIN32
#define WIN32_LEAN_AND_MEAN
#include "windows.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if OGRE_PLATFORM == OGRE_PLATFORM_WIN32
INT WINAPI WinMain( HINSTANCE hInst, HINSTANCE, LPSTR strCmdLine, INT )
#else
int main(int argc, char *argv[])
#endif
{
	// Create application object
	RobotsApp app;

	try
	{
		app.go();
	} catch( Ogre::Exception& e ) {
#if OGRE_PLATFORM == OGRE_PLATFORM_WIN32
		MessageBox( NULL, e.getFullDescription().c_str(), "An exception has occured!", MB_OK | MB_ICONERROR| MB_TASKMODAL);
#else
		std::cerr << "An exception has occured: " << e.getFullDescription().c_str() << std::endl;
#endif
	}

	return 0;
}

#ifdef __cplusplus
}


#endif
