/*
 * OgreBulletExample.h
 *
 *  Created on: Feb 3, 2011
 *      Author: cpresser
 */

#ifndef ROBOTSAPP_H_
#define ROBOTSAPP_H_

#include "BaseApplication.h"

#include <OgreBulletDynamicsRigidBody.h>
#include <deque>
#include "Constants.h"
#include "PlayerBot.h"
#include "StandardBot.h"
#include "WarpBot.h"
#include "FastBot.h"
#include "Lightning.h"
#include "BarrierBot.h"
#include "LaserBot.h"
#include "Beam.h"
#include "DemonLaserBot.h"

class RobotsApp: public BaseApplication {
public:
	RobotsApp();
	virtual ~RobotsApp();

	void createScene();

	//frame listener methods
    // Ogre::FrameListener
    virtual bool frameRenderingQueued(const Ogre::FrameEvent& evt);
    virtual bool frameStarted (const Ogre::FrameEvent &evt);
    virtual bool frameEnded (const Ogre::FrameEvent &evt);

    // OIS::KeyListener
    virtual bool keyPressed( const OIS::KeyEvent &arg );
    virtual bool keyReleased( const OIS::KeyEvent &arg );


protected:

    OgreBulletDynamics::DynamicsWorld *m_world;
    OgreBulletCollisions::DebugDrawer *m_debugDrawer;

    std::deque<OgreBulletDynamics::RigidBody *> m_bodies;
    std::deque<OgreBulletCollisions::CollisionShape *> m_shapes;

    int m_numEntities;
    int m_moveSpeed;
    Ogre::Vector3 m_gravity;
    Ogre::AxisAlignedBox m_bounds;

    Grid *grid;
    PlayerBot * player;
    Robot * test;
    StandardBot * SBtest;
    WarpBot * WBtest;
    std::vector<Robot*> robots;
    Lightning * bolt;
    Beam * testBeam;
    ParticleSystem * selected;
    SceneNode* selNode;
    int gameState;
    Real timeInState;
    int currentID;
    int currentLevel;
    Ogre::RaySceneQuery *mRaySceneQuery;
    GameNode* selectedNode;
    std::vector<GameNode*> playerNeighbors;
    virtual int getID();
    virtual void movePlayer(GameNode* dest);
    virtual void warpPlayer();
    virtual void stepBots();
    virtual void setUpNextMove();
    virtual void setUpLevel(int level);
    virtual void setUpSingleBotLevel(int level);
    virtual void changeState(int newState);
    virtual void changeLevel(int level);
    void createFrameListener(void);
    bool mousePressed( const OIS::MouseEvent& evt, OIS::MouseButtonID id );
    virtual void printOrbiters();
    virtual bool isGameOver();
    virtual bool botsDone();
};

#endif /* ROBOTSAPP_H_ */
