/*
 * SBOrbiter.cpp
 *
 *  Created on: Feb 23, 2015
 *      Author: robijo04
 */
#include "SBOrbiter.h"
#include "Constants.h"
#include "Subcore.h"
SBOrbiter::SBOrbiter() {
	m_isInitialized=false;
	mesh="SBsubCore.mesh";
	orbits=true;
	rotates=false;
	Vector3 o(0,.4,0);
	offset=o;
}

SBOrbiter::~SBOrbiter(void) {

}
void SBOrbiter::init(SceneManager * sceneMgr, Robot * parent, Real radius,
		Real tanSpeed, int id ){
	if(m_isInitialized)return;

	Orbiter::init( sceneMgr, parent,  radius,tanSpeed, Vector3 (0,0,0), Vector3 (0,0,0),Vector3(0,1,0),Vector3(1,0,0) , Vector3(0,0,1),parent->m_grid->m_world, id );
	m_entity->setMaterialName("OrangeCore");
	Ogre::String number = Ogre::StringConverter::toString(id);
	name=parent->name+"Orbiter"+number;
	m_coreLight=sceneMgr->createLight(name+"Light");
	m_coreLight->setType(Light::LT_POINT);
	//m_coreLight->setDiffuseColour(200,50,0);
	//m_coreLight->setSpecularColour(200,50,0);
	m_sceneNode->scale(.15,.15,.15);
	m_sceneNode->attachObject(m_coreLight);
	m_position=m_position+offset;
	m_sceneNode->setPosition(m_position);
	plasmaCore=m_sceneMgr->createParticleSystem(name+"plasmaCore","JDR/Core");
	plasmaCore->getEmitter(0)->setColour(parent->robotColor);
	m_sceneNode->attachObject(plasmaCore);
}

void SBOrbiter::orbit(const FrameEvent &evt){
	//std::cerr<<"SBOrbiting"<<std::endl;
	Real t=evt.timeSinceLastFrame;
	Vector3 v=m_direction*m_tanSpeed;
	Vector3 toParent=offset-m_position;
	toParent.normalise();
	Vector3 a=m_tanSpeed*m_tanSpeed/radius*(toParent);
	v=v+a*t;
	m_position = m_position + (v * t);
	m_sceneNode->setPosition(m_position);
	v.normalise();

	//std::cerr<<"v="<<v<<" a="<<a<<" m_position="<<m_position<<std::endl;
	m_direction=v;
}
void SBOrbiter::die(){
	if(alive){
		ParticleEmitter * em=plasmaCore->getEmitter(0);
		em->setEmissionRate(5);
		em->setTimeToLive(.3,.4);
		Orbiter::die();
		m_entity->setMaterialName("OrangeCore");
		m_sceneNode->attachObject(plasmaCore);
	}
}
OgreBulletCollisions::CollisionShape * SBOrbiter::storedOrbiterCollisionShape=0;
bool SBOrbiter::shapeMade=false;
void  SBOrbiter::setOrbiterCollisionShape(OgreBulletCollisions::CollisionShape * orbiterCollisionShape)
{
	SBOrbiter::storedOrbiterCollisionShape=orbiterCollisionShape;
	SBOrbiter::shapeMade=true;
}
OgreBulletCollisions::CollisionShape * SBOrbiter::getCollisionShape(){
	if(!SBOrbiter::shapeMade){
		Ogre::Matrix4 transform = Ogre::Matrix4::IDENTITY;
		transform.setScale(Vector3(m_sceneNode->_getDerivedScale()*.75));
		OgreBulletCollisions::StaticMeshToShapeConverter makeShape(m_entity, transform);
		setOrbiterCollisionShape( makeShape.createConvexDecomposition());
	}
	return SBOrbiter::storedOrbiterCollisionShape;
}
