/*
 * SBOrbiter.h
 *
 *  Created on: Apr 15, 2015
 *      Author: robijo04
 */

#ifndef SBORBITER_H_
#define SBORBITER_H_
#include <OgreSceneManager.h>
#include <OgreEntity.h>
#include <OgreFrameListener.h>
#include <OgreString.h>

#include <OgreBulletDynamicsRigidBody.h>
#include <deque>
#include <Shapes/OgreBulletCollisionsSphereShape.h>
#include "Orbiter.h"
#include "Constants.h"

class Robot;
class Grid;


using namespace Ogre;
class SBOrbiter: public Orbiter{
public:
	SBOrbiter();
	virtual ~SBOrbiter();
	virtual void init(SceneManager * sceneMgr, Robot * parent, Real radius, Real tanSpeed, int id );
	virtual void orbit(const FrameEvent& evt);
	virtual void die();
	Vector3 offset;
	Light * m_coreLight;
	ParticleSystem * plasmaCore;
protected:
	static OgreBulletCollisions::CollisionShape * storedOrbiterCollisionShape;
	static void setOrbiterCollisionShape(OgreBulletCollisions::CollisionShape * orbiterCollisionShape);
	static bool shapeMade;
	virtual OgreBulletCollisions::CollisionShape * getCollisionShape();
};


#endif /* SBORBITER_H_ */
