/*
 * StandardBot.cpp
 *
 *  Created on: Apr 15, 2015
 *      Author: robijo04
 */
#include "StandardBot.h"
#include "Constants.h"
#include "SBOrbiter.h"
OgreBulletCollisions::CollisionShape * StandardBot::storedShellCollisionShape=0;
bool StandardBot::shapeMade=false;
StandardBot::StandardBot(){
	alive=true;
	converted=false;
	timeMoving=0;
	numJumps=1;
	m_isInitialized=false;
	robotColor=ColourValue(8.0f,0.2f,0.0f,0.5f);
	materialName="OrangeCore";
	m_shellRigidBody=0;
	m_shellCollisionShape=0;
}
StandardBot::~StandardBot(){
	std::cout<<"Deleting Standard Bot"<<std::endl;

	if(m_shellRigidBody){
		//m_grid->m_world->removeObject(m_shellRigidBody);
		delete m_shellRigidBody;
		m_shellRigidBody=0;
	}
	std::cout<<"rigid body Deleted"<<std::endl;
	shellNode->detachAllObjects();
	m_sceneMgr->destroyEntity(shell->getName());
	shellNode->getParentSceneNode()->removeChild(shellNode);
	m_sceneMgr->destroySceneNode(shellNode->getName());
	std::cout<<"Shell Deleted"<<std::endl;
	//Robot::~Robot();
}

void StandardBot::init(Ogre::SceneManager *sceneMgr,Grid * grid, GameNode * currentNode, int id){

	if(m_isInitialized){
		return;
	}

	Robot::init(sceneMgr, grid, currentNode, id);
	m_core->setMaterialName(materialName);
	//m_coreLight->setDiffuseColour(0,255,255);
	//m_coreLight->setSpecularColour(0,255,255);
	Real radius=SCALE*.75;
	Vector3 dir(0,1,0);
	shellNode=m_sceneNode->createChildSceneNode(name+"ShellNode");
	shell=sceneMgr->createEntity("SBShell.mesh");
	shellNode->attachObject(shell);
	shellNode->scale(1.4,1.4,1.4);
	if(!shapeMade){
		Ogre::Matrix4 transform = Ogre::Matrix4::IDENTITY;
		transform.setScale(Vector3(m_sceneNode->_getDerivedScale()));
		OgreBulletCollisions::StaticMeshToShapeConverter makeShape(shell, transform);
		StandardBot::setCollisionShape(makeShape.createConvexDecomposition());
	}
	m_shellCollisionShape=new OgreBulletCollisions::CollisionShape(*storedShellCollisionShape);
	SBOrbiter * orbit= new SBOrbiter();
	orbit->init(sceneMgr, this, 1.25, 5, id );
	m_orbiters.push_back(orbit);
}
void StandardBot::die(){
	if(alive){
		Robot::die();

		SceneNode * newSceneNode=m_sceneMgr->getRootSceneNode()->createChildSceneNode(name+"Shell_PhysicsNode");
		newSceneNode->scale(m_sceneNode->_getDerivedScale());
		newSceneNode->setPosition(m_sceneNode->_getDerivedPosition());
		newSceneNode->setOrientation(m_sceneNode->_getDerivedOrientation());
		Entity * newEnt= m_sceneMgr->createEntity(name+"ShellPhysics", "SBShell.mesh");
		newEnt->setMaterialName("GunMetal");
		newSceneNode->attachObject(newEnt);

		shellNode->detachAllObjects();
		m_sceneMgr->destroyEntity(shell->getName());
		m_sceneMgr->destroySceneNode(shellNode->getName());
		shell=newEnt;
		shellNode=newSceneNode;

		m_shellRigidBody = new OgreBulletDynamics::RigidBody(name + "_BODY", m_grid->m_world);

		m_shellRigidBody->setShape(shellNode, StandardBot::storedShellCollisionShape,.5, .5, 1,shellNode->_getDerivedPosition(),shellNode->_getDerivedOrientation());
	}
}
void  StandardBot::setCollisionShape(OgreBulletCollisions::CollisionShape *shellCollisionShape)
{
	StandardBot::storedShellCollisionShape=shellCollisionShape;
	StandardBot::shapeMade=true;
}
