/*
 * Subcore.cpp
 *
 *  Created on: May 5, 2015
 *      Author: robijo04
 */
#include "Subcore.h";
#include "Constants.h";
Subcore::Subcore() {
	m_materialName="GunMetal";
	m_isInitialized=false;
	m_mesh="Core.mesh";

}
Subcore::~Subcore(void) {
	m_sceneNode->detachObject(m_entity);
	m_sceneNode->detachObject(m_plasmaCore);
	m_sceneNode->detachObject(m_coreLight);
	m_sceneMgr->destroyEntity(m_entity->getName());
	m_sceneMgr->destroyParticleSystem(m_plasmaCore);
	m_sceneMgr->destroyLight(m_coreLight);
	m_sceneMgr->destroySceneNode(m_sceneNode->getName());
}

void Subcore::init(SceneManager * sceneMgr, Robot * parent, SceneNode * node, Vector3 position, Vector3 scale, int id){
	if(m_isInitialized) return;
	String number = StringConverter::toString(id);
	m_name=parent->name+"SubCore"+number;
	m_sceneNode= node->createChildSceneNode(m_name+"Node");
	m_sceneNode->setPosition(position);
	m_parent=parent;
	m_sceneMgr=sceneMgr;
	m_entity=m_sceneMgr->createEntity(m_name, m_mesh);
	m_entity->setMaterialName(parent->materialName);
	m_sceneNode->attachObject(m_entity);
	m_sceneNode->scale(scale);
	m_coreLight=sceneMgr->createLight(m_name+"Light");
	m_coreLight->setType(Light::LT_POINT);
	m_coreLight->setDiffuseColour(parent->robotColor);
	m_coreLight->setSpecularColour(parent->robotColor);
	m_sceneNode->attachObject(m_coreLight);
	m_plasmaCore=m_sceneMgr->createParticleSystem(m_name+"plasmaCore","JDR/Core");
	m_plasmaCore->getEmitter(0)->setColour(parent->robotColor);
	m_sceneNode->attachObject(m_plasmaCore);
	m_isInitialized=true;
}
void Subcore::changeParentNode(SceneNode * node){
	Vector3 scale=m_sceneNode->getScale();
	Vector3 position=m_sceneNode->getPosition();
	m_sceneNode->detachObject(m_entity);
	m_sceneNode->detachObject(m_plasmaCore);
	m_sceneNode->detachObject(m_coreLight);
	m_sceneMgr->destroySceneNode(m_sceneNode->getName());
	m_sceneNode= node->createChildSceneNode(m_name+"Node");
	m_sceneNode->attachObject(m_entity);
	m_sceneNode->attachObject(m_coreLight);
	m_sceneNode->attachObject(m_plasmaCore);
	m_sceneNode->scale(scale);
	m_sceneNode->setPosition(position);
}
