/*
 * Subcore.h
 *
 *  Created on: May 5, 2015
 *      Author: robijo04
 */

#ifndef SUBCORE_H_
#define SUBCORE_H_

#include <OgreSceneManager.h>
#include <OgreEntity.h>
#include <OgreFrameListener.h>
#include <OgreString.h>

#include <OgreBulletDynamicsRigidBody.h>
#include <deque>
#include <Shapes/OgreBulletCollisionsSphereShape.h>


class Robot;
class Grid;

using namespace Ogre;
class Subcore{
public:
	Subcore();
	virtual ~Subcore();
	Entity * m_entity;
	SceneNode * m_sceneNode;
	SceneManager* m_sceneMgr;
	Robot * m_parent;
	String m_name;
	String m_mesh;
	String m_materialName;//set for each subclass
	ParticleSystem * m_plasmaCore;
	Light * m_coreLight;
	bool m_isInitialized;
	virtual void init(SceneManager * sceneMgr, Robot * parent, SceneNode * node, Vector3 position, Vector3 scale, int id);
	virtual void changeParentNode(SceneNode * node);
};



#endif /* SUBCORE_H_ */
