/*
 * WBOrbiter.cpp
 *
 *  Created on: Feb 23, 2015
 *      Author: robijo04
 */
#include "WBOrbiter.h"
#include "Constants.h"
WBOrbiter::WBOrbiter() {
	m_isInitialized=false;

	orbits=false;
	rotates=true;
}

WBOrbiter::~WBOrbiter(void) {
}
void WBOrbiter::init(SceneManager * sceneMgr, Robot * parent,
		Real tanSpeed, int type, int id ){
	if(m_isInitialized)return;
	Vector3 dir;
	if(type==cOUT){
		dir=Vector3(1,0,0);
		mesh="OuterRing.mesh";
	}else if(type==cMID){
		dir=Vector3(0,0,1);
		mesh="MidRing.mesh";
	}else if(type==cIN){
		dir=Vector3(0,1,0);
		mesh="InnerRing.mesh";
	}

	Orbiter::init( sceneMgr, parent,  1,tanSpeed, Vector3(0,0,0), dir, Vector3 (0,0,0), Vector3 (0,0,0), Vector3 (0,0,0), parent->m_grid->m_world,id );
	m_entity->setMaterialName("GunMetal");
	m_sceneNode->scale(1.1,1.1,1.1);

//	//outerRing->pitch(Ogre::Degree(90)*evt.timeSinceLastFrame);
//		outerRing->rotate(Ogre::Vector3(1,0,0),rotationSpeed*evt.timeSinceLastFrame);
//		//midRing->roll(Ogre::Degree(90)*evt.timeSinceLastFrame);
//		midRing->rotate(Ogre::Vector3(0,1,0),rotationSpeed*evt.timeSinceLastFrame,Ogre::Node::TS_PARENT);
//		//innerRing->yaw(Ogre::Degree(90)*evt.timeSinceLastFrame);
//		innerRing->rotate(Ogre::Vector3(0,0,1),rotationSpeed*evt.timeSinceLastFrame);

}
OgreBulletCollisions::CollisionShape * WBOrbiter::storedOrbiterCollisionShape=0;
bool WBOrbiter::shapeMade=false;
void  WBOrbiter::setOrbiterCollisionShape(OgreBulletCollisions::CollisionShape * orbiterCollisionShape)
{
	WBOrbiter::storedOrbiterCollisionShape=orbiterCollisionShape;
	WBOrbiter::shapeMade=true;
}
OgreBulletCollisions::CollisionShape * WBOrbiter::getCollisionShape(){
	if(!WBOrbiter::shapeMade){
		Ogre::Matrix4 transform = Ogre::Matrix4::IDENTITY;
		transform.setScale(Vector3(m_sceneNode->_getDerivedScale()*.75));
		OgreBulletCollisions::StaticMeshToShapeConverter makeShape(m_entity, transform);
		setOrbiterCollisionShape( makeShape.createConvexDecomposition());
	}
	return WBOrbiter::storedOrbiterCollisionShape;
}



