/*
 * WarpBot.cpp
 *
 *  Created on: Apr 15, 2015
 *      Author: robijo04
 */
#include "WarpBot.h"
#include "Constants.h"
#include "WBOrbiter.h"

WarpBot::WarpBot(){
	alive=true;
	converted=false;
	timeMoving=0;
	numJumps=1;
	m_isInitialized=false;
	materialName="BlueCore";
	robotColor=ColourValue(0.0f,0.0f,1.0f,0.5f);
}
WarpBot::~WarpBot(){

}

void WarpBot::init(Ogre::SceneManager *sceneMgr,Grid * grid, GameNode * currentNode, int id){

	if(m_isInitialized){
		return;
	}

	Robot::init(sceneMgr, grid, currentNode, id);
	m_core->setMaterialName(materialName);

	//m_coreLight->setDiffuseColour(0,255,255);
	//m_coreLight->setSpecularColour(0,255,255);
	//m_coreLight->setVisible(false);
	Real radius=SCALE*.75;

	for(int i=0;i<3;i++){
		WBOrbiter * orbit= new WBOrbiter();
		//orbit->init(sceneMgr, m_node, i, radius+i*2, Ogre::Degree(45*i), dir);
		orbit->init(sceneMgr, this, 3,i,i);
		m_orbiters.push_back(orbit);

	}

}
void WarpBot::move(GameNode* node){
	if(rand()%5==0){
		warp(m_grid->nodes[rand()%m_grid->nodes.size()]);
	}else{
		Robot::move(node);
	}
}
