/*
 * DirectionPointer.cpp
 *
 *  Created on: Mar 24, 2014
 *      Author: cpresser
 */

#include "DirectionPointer.h"

DirectionPointer::DirectionPointer(
		Ogre::Real min,
		Ogre::Real max,
		Ogre::Real increment,
		Ogre::SceneManager *sceneMgr,
		Ogre::String name,
		Ogre::Vector3 position):
		GameObject(sceneMgr, name, position, "Cone.mesh", "CPresser/SemiClearRed"),
		m_minimum(min),
		m_maximum(max),
		m_increment(increment),
		m_currentValue(0),
		m_motion(0)
{
	m_node->rotate(Ogre::Vector3::UNIT_X, Ogre::Radian(-Ogre::Math::HALF_PI),
			m_node->TS_LOCAL);

}

DirectionPointer::~DirectionPointer() {
}


void DirectionPointer::update(const Ogre::FrameEvent& evt){

	//fix this so the current value
	Ogre::Real rotAmt = m_motion*m_increment*(evt.timeSinceLastFrame);
	m_currentValue += rotAmt;
	if(m_currentValue < m_minimum){
		m_currentValue = m_minimum;
		rotAmt = 0;
	}
	if(m_currentValue > m_maximum){
		m_currentValue = m_maximum;
		rotAmt = 0;
	}

	m_node->rotate(Ogre::Vector3::UNIT_Y, Ogre::Radian(rotAmt),
			m_node->TS_PARENT);

}

const Ogre::Real& DirectionPointer::getCurrentValue() const {
	return m_currentValue;
}

const Ogre::Real& DirectionPointer::getIncrement() const {
	return m_increment;
}

void DirectionPointer::setIncrement(const Ogre::Real& increment) {
	m_increment = increment;
}

const Ogre::Real& DirectionPointer::getMaximum() const {
	return m_maximum;
}

void DirectionPointer::setMaximum(const Ogre::Real& maximum) {
	m_maximum = maximum;
}

const Ogre::Real& DirectionPointer::getMinimum() const {
	return m_minimum;
}

void DirectionPointer::goToMaximum() {
	m_currentValue = m_maximum;
}

void DirectionPointer::goToMinimum() {
	m_currentValue = m_minimum;
}

void DirectionPointer::moveLeft() {
	m_motion = 1;
}

void DirectionPointer::moveRight() {
	m_motion = -1;
}

void DirectionPointer::stopMoving() {
	m_motion = 0;
}

void DirectionPointer::setMinimum(const Ogre::Real& minimum) {
	m_minimum = minimum;
}
