/*
 * DirectionPointer.h
 *
 *  Created on: Mar 24, 2014
 *      Author: cpresser
 */

#ifndef DIRECTIONPOINTER_H_
#define DIRECTIONPOINTER_H_

#include "GameObject.h"

class DirectionPointer: public GameObject {
public:
	DirectionPointer(Ogre::Real min,
			Ogre::Real max,
			Ogre::Real increment,
			Ogre::SceneManager *sceneMgr,
			Ogre::String name,
			Ogre::Vector3 position);

	virtual ~DirectionPointer();

	virtual void update(const Ogre::FrameEvent& evt);

	virtual void moveLeft();
	virtual void moveRight();
	virtual void stopMoving();

	virtual void goToMaximum();
	virtual void goToMinimum();

	const Ogre::Real& getCurrentValue() const;

	const Ogre::Real& getIncrement() const;
	void setIncrement(const Ogre::Real& increment);

	const Ogre::Real& getMaximum() const;
	void setMaximum(const Ogre::Real& maximum);

	const Ogre::Real& getMinimum() const;
	void setMinimum(const Ogre::Real& minimum);

protected:
	Ogre::Real m_minimum;
	Ogre::Real m_maximum;
	Ogre::Real m_increment;
	Ogre::Real m_currentValue;
	Ogre::Real m_motion;
};

#endif /* DIRECTIONPOINTER_H_ */
