/*
 * GameObject.cpp
 *
 *  Created on: Mar 18, 2014
 *      Author: cpresser
 */

#include "GameObject.h"


GameObject::GameObject():
	m_sceneMgr(0),
	m_entity(0),
	m_node(0),
	m_name(),
	m_isSelected(false),
	m_direction(0, 0, 0),
	m_scale(1,1,1),
	m_oldPosition(0, 0, 0),
	m_isInitialized(false),
	m_points(0)
{
}

GameObject::GameObject(Ogre::SceneManager* sceneMgr,
		Ogre::String name, Ogre::Vector3 position, Ogre::String mesh,
		Ogre::String material, Ogre::Vector3 scale):
		m_sceneMgr(sceneMgr),
		m_entity(0),
		m_node(0),
		m_name(name),
		m_isSelected(false),
		m_direction(0, 0, 0),
		m_scale(scale),
		m_oldPosition(0, 0, 0),
		m_isInitialized(false),
		m_points(0)
{
	init(sceneMgr, name, position, mesh, material, scale);

}


GameObject::~GameObject() {
	//Let the SceneManager clean up the object
	if(!m_isInitialized)
		return;

	if(m_node){
		if(m_entity){
			m_node->detachObject(m_entity);
			m_sceneMgr->destroyEntity(m_entity);
		}
		Ogre::SceneNode *parent = m_node->getParentSceneNode();
		parent->removeChild(m_node);
		m_sceneMgr->destroySceneNode(m_node);
	}
}

void GameObject::update(const Ogre::FrameEvent& evt) {
	if(m_isInitialized)
		return;

	m_oldPosition = m_node->getPosition();
	Ogre::Vector3 location = m_oldPosition + (m_direction * evt.timeSinceLastFrame);

	m_node->setPosition(location);
}

Ogre::Vector3& GameObject::getDirection() {
	return m_direction;
}

void GameObject::setDirection(Ogre::Vector3 direction) {
	m_direction = direction;
}

void GameObject::setSelected(bool select) {

	if(!m_isInitialized)
		return;

	m_isSelected = select;
	m_node->showBoundingBox(select);

	if(select){
		m_entity->setQueryFlags(1);
	}
	else {
		m_entity->setQueryFlags(2);
	}
}

bool GameObject::isSelected() {
	return m_isSelected;
}

Ogre::String GameObject::getName() {
	return m_name;
}

Ogre::String GameObject::getEntityName() {
	return m_entity->getName();
}

Ogre::String GameObject::getNodeName() {
	return m_node->getName();
}

Ogre::AxisAlignedBox GameObject::getTransformedBoundingBox() {
	if(!m_isInitialized)
		return Ogre::AxisAlignedBox();

	return m_entity->getWorldBoundingBox();
}


void GameObject::stepBack() {
	m_node->setPosition(m_oldPosition);
}

bool GameObject::isInitialized() {
	return m_isInitialized;
}

void GameObject::init(Ogre::SceneManager* sceneMgr, Ogre::String name,
		Ogre::Vector3 position, Ogre::String mesh, Ogre::String material,
		Ogre::Vector3 scale) {

	if(m_isInitialized)
		return;

	m_sceneMgr = sceneMgr;
	m_name = name;


	//set up the entity
	m_entity = m_sceneMgr->createEntity(name, mesh);
	m_entity->setCastShadows(true);


	//set up the scene node
	m_node = m_sceneMgr->getRootSceneNode()->createChildSceneNode(name + "Node");
	m_node->attachObject(m_entity);

	m_scale = scale;
	m_node->scale(m_scale);

	//set the position
	m_node->setPosition(position);
	m_oldPosition = position;

	//set the material if any
	if(material != ""){
		m_entity->setMaterialName(material);
	}

	m_isInitialized = true;
}
