/*
 * OgreGOB.cpp
 *
 *  Created on: Mar 27, 2014
 *      Author: cpresser
 */

#include "OgreGOB.h"

OgreGOB::OgreGOB() {
	// TODO Auto-generated constructor stub

}

OgreGOB::OgreGOB(OgreBulletDynamics::DynamicsWorld* world,
		Ogre::SceneManager* sceneMgr, Ogre::String name,
		Ogre::Vector3 position):
				PhysicsGameObject(world, 1.0f, 1.0f, 10.0f,
						false, sceneMgr, name, position,
						"Sinbad.mesh", "",
						2*Ogre::Vector3::UNIT_SCALE)
{

	m_animState = m_entity->getAnimationState("Dance");
	m_points = 50;
}

OgreGOB::~OgreGOB() {
	// TODO Auto-generated destructor stub
}

OgreBulletCollisions::CollisionShape* OgreGOB::createCollisionShape() {
	//return createSphereCollisionShape();
	return createCylinderCollisionShape();
}

void OgreGOB::update(const Ogre::FrameEvent& evt) {
	if(m_animState){
			m_animState->addTime(evt.timeSinceLastFrame);
	}
}

void OgreGOB::dance() {
	if(m_animState){
		m_animState->setLoop(true);
		m_animState->setEnabled(true);
	}
}

void OgreGOB::stopDancing() {
	if(m_animState){
		m_animState->setEnabled(false);
	}
}
