/*
 * PhysicsGameObject.h
 *
 *  Created on: Mar 22, 2014
 *      Author: cpresser
 */

#ifndef PHYSICSGAMEOBJECT_H_
#define PHYSICSGAMEOBJECT_H_

#include "GameObject.h"

#include <OgreBulletDynamics.h>
#include <OgreBulletCollisions.h>

class PhysicsGameObject: public GameObject {
public:
	PhysicsGameObject();

	PhysicsGameObject(OgreBulletDynamics::DynamicsWorld *world,
			float restitution,
			float friction,
			float mass,
			bool dynamic,
			Ogre::SceneManager *sceneMgr,
			Ogre::String name,
			Ogre::Vector3 position,
			Ogre::String mesh,
			Ogre::String material = "",
			Ogre::Vector3 scale = Ogre::Vector3::UNIT_SCALE);

	virtual ~PhysicsGameObject();

	virtual void init(OgreBulletDynamics::DynamicsWorld *world,
			float restitution,
			float friction,
			float mass,
			bool dynamic,
			Ogre::SceneManager *sceneMgr,
			Ogre::String name,
			Ogre::Vector3 position,
			Ogre::String mesh,
			Ogre::String material = "",
			Ogre::Vector3 scale = Ogre::Vector3::UNIT_SCALE);

	virtual const btCollisionObject *getBulletCollisionObject();

protected:
	//Creates a basic box collision shape,
	//Override for different shapes.
	virtual OgreBulletCollisions::CollisionShape *createCollisionShape();

	//utility methods for creating different collision shapes that fit the entity
	OgreBulletCollisions::CollisionShape *createBoxCollisionShape();
	OgreBulletCollisions::CollisionShape *createSphereCollisionShape();
	OgreBulletCollisions::CollisionShape *createCylinderCollisionShape();
	OgreBulletCollisions::CollisionShape *createConcaveCollisionShape();


protected:
	//INSTANCE VARIABLES
	OgreBulletCollisions::CollisionShape *m_collisionShape;
	OgreBulletDynamics::RigidBody *m_rigidBody;

    //"Physical" properties
	float m_restitution;  //bounciness
	float m_friction;
	float m_mass;

};

#endif /* PHYSICSGAMEOBJECT_H_ */
