/*
 * PizzaGOB.cpp
 *
 *  Created on: Mar 24, 2014
 *      Author: cpresser
 */

#include "PizzaGOB.h"


#include <OgreBulletDynamicsRigidBody.h>
#include <Shapes/OgreBulletCollisionsCylinderShape.h>

PizzaGOB::PizzaGOB() {

}

PizzaGOB::PizzaGOB(OgreBulletDynamics::DynamicsWorld* world,
		Ogre::SceneManager* sceneMgr, Ogre::String name,
		Ogre::Vector3 position):
				PhysicsGameObject(world, 1, 0, 4, true,
						sceneMgr, name, position, "Pizza2.mesh", "")
{
}

PizzaGOB::~PizzaGOB() {
}

void PizzaGOB::firePizza(Ogre::Real angle) {

	//figure out the direction to shoot
	Ogre::Quaternion quat(Ogre::Radian(angle), Ogre::Vector3::UNIT_Y);
	Ogre::Vector3 dir = quat*Ogre::Vector3::NEGATIVE_UNIT_Z;

	//turn on physics (in case it was resting)
	m_rigidBody->enableActiveState();

	//send it on its way
	m_rigidBody->setLinearVelocity(150*dir);
	//m_rigidBody->setDamping(0.1, 0.1);

}

bool PizzaGOB::isMoving() {
	//float d = m_rigidBody->getLinearVelocity().squaredLength();
	//return (d < -0.1 || d > -0.1);
	return m_rigidBody->getLinearVelocity() != Ogre::Vector3::ZERO;
}

void PizzaGOB::reset() {
	m_rigidBody->setPosition(m_oldPosition);
}

OgreBulletCollisions::CollisionShape* PizzaGOB::createCollisionShape() {
	return createSphereCollisionShape();
	//return createCylinderCollisionShape();
}
