/*
 * PizzaShooterApp.h
 *
 *  Created on: Mar 18, 2014
 *      Author: cpresser
 */

#ifndef PIZZASHOOTERAPP_H_
#define PIZZASHOOTERAPP_H_

#include "BaseApplication.h"
#include "GameObject.h"
#include "PhysicsGameObject.h"


#include <OgreBulletDynamicsRigidBody.h>
// Hashmap type data structure
#include <map>

class PizzaShooterApp : public BaseApplication {
public:
	static const int FLOOR_LENGTH = 10000;
	static const int SPEED = 100;
	static const Ogre::Vector3 DEFAULT_CAMERA_LOCATION;
	static const Ogre::Vector3 DEFAULT_CAMERA_LOOK_AT;

public:
	PizzaShooterApp();
	virtual ~PizzaShooterApp();

protected:
	//methods for setting up the application
	virtual void createScene();
	virtual void createFrameListener();

	// Ogre::FrameListener methods
	virtual bool frameEnded(const Ogre::FrameEvent & evt);
	virtual bool frameStarted(const Ogre::FrameEvent & evt);
	virtual bool frameRenderingQueued(const Ogre::FrameEvent& evt);

	// OIS:KeyListener
	virtual bool keyPressed(const OIS::KeyEvent& evt);
	virtual bool keyReleased(const OIS::KeyEvent& evt);

	// OIS:MouseListener
	virtual bool mouseMoved( const OIS::MouseEvent& evt );
	virtual bool mousePressed( const OIS::MouseEvent& evt, OIS::MouseButtonID id );
	virtual bool mouseReleased( const OIS::MouseEvent& evt, OIS::MouseButtonID id );


	virtual void firePizza();
	virtual void manageCollisions();

	virtual void createStack(Ogre::Vector3 position);

	PhysicsGameObject *getObjectFromBulletCollision(const btCollisionObject *obj);
private:

	//some data structure for holding objects?
	std::map<Ogre::String, GameObject *> m_objectMap;

	//hold a pointer to whichever object is selected
	GameObject *m_selectedObject;

	//use this object to pick an object from the scene
	Ogre::RaySceneQuery *m_rayQuery;

	//
	//physics simulation member:
	//

	//direction of gravity
    Ogre::Vector3 m_gravity;

    //bounding box for simulation
    Ogre::AxisAlignedBox m_bounds;

	//The simulation environment
    OgreBulletDynamics::DynamicsWorld *m_world;
    //This is used to draw objects that help in debugging
    OgreBulletCollisions::DebugDrawer *m_debugDrawer;

    bool m_shotFired;
    int m_numTargets;
    int m_score;
    OgreBites::ParamsPanel *m_resultPanel;

};

#endif /* PIZZASHOOTERAPP_H_ */
