/*
 * PlaneGOB.cpp
 *
 *  Created on: Mar 22, 2014
 *      Author: cpresser
 */

#include "PlaneGOB.h"


#include <Shapes/OgreBulletCollisionsStaticPlaneShape.h>

PlaneGOB::PlaneGOB():
	m_normal(Ogre::Vector3::UNIT_Y)
{
}

PlaneGOB::PlaneGOB(Ogre::Vector3 normal, Ogre::Real width, Ogre::Real height,
		OgreBulletDynamics::DynamicsWorld* world, float restitution,
		float friction, Ogre::SceneManager* sceneMgr, Ogre::String name,
		Ogre::Vector3 position, Ogre::String material)
{
	init(normal, width, height, world, restitution, friction,
			sceneMgr, name, position, material);
}

PlaneGOB::~PlaneGOB() {
}

void PlaneGOB::init(Ogre::Vector3 normal, Ogre::Real width,
		Ogre::Real height, OgreBulletDynamics::DynamicsWorld* world,
		float restitution, float friction, Ogre::SceneManager* sceneMgr,
		Ogre::String name, Ogre::Vector3 position, Ogre::String material) {

	m_normal = normal;

	//set up plane
    Ogre::Plane plane(normal, 0);
    Ogre::String meshName = name + "_PLANE";


    //the up direction can't be parallel to the plane's normal, so we will fixe this
    Ogre::Vector3 up = Ogre::Vector3::UNIT_Z;
    if(normal == Ogre::Vector3::UNIT_Z || normal == Ogre::Vector3::NEGATIVE_UNIT_Z ){
    	up = Ogre::Vector3::UNIT_Y;
    }

    Ogre::MeshManager::getSingleton().createPlane(meshName,
    		Ogre::ResourceGroupManager::DEFAULT_RESOURCE_GROUP_NAME,
    		plane, width, height, 20, 20, true, 1, width/10, height/10,
    		up);

	//call superclass init
	PhysicsGameObject::init(world, restitution, friction, 1.0, false, sceneMgr,
			name, position, meshName, material);
}

OgreBulletCollisions::CollisionShape* PlaneGOB::createCollisionShape() {
   return new OgreBulletCollisions::StaticPlaneCollisionShape(m_normal, 0);
}
