/*
 * Rectangle.cpp
 *
 *  Created on: Jan 26, 2015
 *      Author: cpresser
 */

#include "Rectangle.h"

#include <iostream>

//Constructor: the first item in the initializer list
// is the call to the superclass constructor.
Rectangle::Rectangle(int x, int y, int w, int h):
	Shape(x, y),
	m_width(w),
	m_height(h)
{
	//by the time we get here, instance variables will already have been created
}

//Destructor
Rectangle::~Rectangle() {
	//used to destroy stuff (which generally, we won't do)
}


//Getters and Setters

int Rectangle::getHeight() const {
	return m_height;
}

void Rectangle::setHeight(int height) {
	m_height = height;
}

int Rectangle::getWidth() const {
	return m_width;
}

double Rectangle::getArea() {
	return m_width*m_height;
}

void Rectangle::setWidth(int width) {
	m_width = width;
}

