/*
 * Shape.cpp
 *
 *  Created on: Jan 26, 2015
 *      Author: cpresser
 */

#include "Shape.h"

//Constructor
// instance variable initializers, so they aren't created twice
// this is more important for objects.
Shape::Shape(int x, int y):
	m_x(x),
	m_y(y)
{
}

//destructor
Shape::~Shape() {
	//nothing to clean up
}

//Getters and setters

//const at the end indicates that this method will not change
// the state of the object
int Shape::getX() const {
	return m_x;
}

void Shape::setX(int x) {
	m_x = x;
}

int Shape::getY() const {
	return m_y;
}

void Shape::setY(int y) {
	m_y = y;
}
