/*
 * Shape.h
 *
 *  Created on: Jan 26, 2015
 *      Author: cpresser
 */

//Make sure this file is not included twice
#ifndef SHAPE_H_
#define SHAPE_H_

//Abstract class Shape, defines positions and a getArea method
class Shape {
public:
	//constructor
	Shape(int x, int y);

	//destructor
	virtual ~Shape();

	//pure virtual (abstract) method getArea
	virtual double getArea() = 0;

	//getters and setters
	int getX() const;
	void setX(int x);
	int getY() const;
	void setY(int y);

protected:
	//instance variables
	int m_x;
	int m_y;
}; //end of class Shape
//NOTE: semicolon here!

#endif /* SHAPE_H_ */
