import java.util.Arrays;

public class PetersonSolution extends MutexProblem {

	private int n = 0;
	private volatile int turn = 0;
	private boolean[] interested = new boolean[2];
	
	@Override
	AbstractProcess createProcess(int type) {
		if(n >= 2)
			return null;
		return new PetersonProcess(n++);
	}

	@Override
	public String toString() {
		return "Interests: " + Arrays.toString(interested);
	}

	class PetersonProcess extends AbstractProcess {
		private int id;
		
		public PetersonProcess(int n) {
			super(n);
			id = n;
		}

		@Override
		protected boolean entrySection() {
			int other = 1 - id;
			interested[id] = true;
			turn = id;
			while(turn == id && interested[other]);
			return true;
		}

		@Override
		protected void exitSection() {
			interested[id] = false;
		}
		
		
	}
	
}
